/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Footnote;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.text.RtfParagraph;
import com.lowagie.text.rtf.text.RtfPhrase;
import java.io.IOException;
import java.io.OutputStream;

public class RtfFootnote
extends RtfPhrase {
    private static final byte[] FOOTNOTE = DocWriter.getISOBytes((String)"\\*\\footnote");
    private static final byte[] SUPER = DocWriter.getISOBytes((String)"\\super");
    private static final byte[] CHFTN = DocWriter.getISOBytes((String)"\\chftn");
    protected RtfParagraphStyle paragraphStyle = null;

    public RtfFootnote(RtfDocument doc, Footnote footnote) {
        super(doc);
        RtfFont baseFont = null;
        if (footnote.getFont() instanceof RtfParagraphStyle) {
            this.paragraphStyle = this.document.getDocumentHeader().getRtfParagraphStyle(((RtfParagraphStyle)footnote.getFont()).getStyleName());
            baseFont = this.paragraphStyle;
        } else {
            baseFont = new RtfFont(this.document, footnote.getFont());
            this.paragraphStyle = new RtfParagraphStyle(this.document, this.document.getDocumentHeader().getRtfParagraphStyle("Normal"));
        }
        for (int i = 0; i < footnote.size(); ++i) {
            Element chunk = (Element)footnote.get(i);
            if (chunk instanceof Chunk) {
                ((Chunk)chunk).setFont(baseFont.difference(((Chunk)chunk).getFont()));
            }
            try {
                RtfBasicElement[] rtfElements = doc.getMapper().mapElement(chunk);
                for (int j = 0; j < rtfElements.length; ++j) {
                    this.chunks.add(rtfElements[j]);
                }
                continue;
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
    }

    @Override
    public void writeContent(OutputStream result) throws IOException {
        result.write(OPEN_GROUP);
        result.write(OPEN_GROUP);
        result.write(SUPER);
        result.write(CHFTN);
        result.write(OPEN_GROUP);
        result.write(FOOTNOTE);
        result.write(CHFTN);
        result.write(RtfParagraph.PARAGRAPH_DEFAULTS);
        result.write(RtfParagraph.PLAIN);
        if (this.paragraphStyle != null) {
            this.paragraphStyle.writeBegin(result);
        }
        for (int i = 0; i < this.chunks.size(); ++i) {
            RtfBasicElement rbe = (RtfBasicElement)this.chunks.get(i);
            rbe.writeContent(result);
        }
        if (this.paragraphStyle != null) {
            this.paragraphStyle.writeEnd(result);
        }
        result.write(CLOSE_GROUP);
        result.write(CLOSE_GROUP);
        result.write(CLOSE_GROUP);
    }
}

