/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.util;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;

public final class Sets {
    private static final Pattern ID_SPLIT_PATTERN = Pattern.compile("\\s*(\\s|,)\\s*");
    private static final String BRACKETS = "\\[.*\\]";

    private Sets() {
    }

    public static Set<String> asSet(Object valueToSet) {
        if (null != valueToSet) {
            if (valueToSet instanceof Set) {
                return new LinkedHashSet<String>((Set)valueToSet);
            }
            if (valueToSet instanceof Collection) {
                return new LinkedHashSet<String>((Collection)valueToSet);
            }
            if (Object[].class.isAssignableFrom(valueToSet.getClass())) {
                return new LinkedHashSet<String>(Arrays.asList((String[])valueToSet));
            }
            if (valueToSet instanceof String) {
                String areasString = ((String)valueToSet).trim();
                if (Pattern.matches(BRACKETS, areasString)) {
                    areasString = areasString.substring(1, areasString.length() - 1);
                }
                if (areasString.contains(",") || areasString.contains(" ")) {
                    String[] values = ID_SPLIT_PATTERN.split(areasString);
                    LinkedHashSet<String> result = new LinkedHashSet<String>(values.length);
                    for (String value : values) {
                        if (Strings.isNullOrEmpty((String)value)) continue;
                        result.add(value);
                    }
                    return result;
                }
                LinkedHashSet<String> areasSet = new LinkedHashSet<String>(5);
                if (!Strings.isNullOrEmpty((String)areasString)) {
                    areasSet.add(areasString);
                }
                return areasSet;
            }
        }
        return null;
    }
}

