/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.javascript;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ajax4jsf.javascript.ScriptString;
import org.ajax4jsf.javascript.ScriptStringBase;

public class JSFunctionDefinition
extends ScriptStringBase
implements ScriptString {
    private List<Object> parameters = new ArrayList<Object>();
    private StringBuffer body = new StringBuffer();
    private String name;

    public JSFunctionDefinition(Object ... params) {
        this.parameters.addAll(Arrays.asList(params));
    }

    public void addParameter(Object param) {
        this.parameters.add(param);
    }

    public JSFunctionDefinition addToBody(Object body) {
        this.body.append(body);
        return this;
    }

    @Override
    public void appendScript(Appendable target) throws IOException {
        this.appendFunctionName(target);
        this.appendParameters(target);
        target.append("{");
        this.appendBody(target);
        target.append("}");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void appendFunctionName(Appendable target) throws IOException {
        if (null != this.name) {
            target.append(this.name).append(" = ");
        }
        target.append("function");
    }

    protected void appendBody(Appendable target) throws IOException {
        target.append(this.body);
    }

    private void appendParameters(Appendable target) throws IOException {
        target.append("(");
        boolean first = true;
        for (Object element : this.parameters) {
            if (!first) {
                target.append(",");
            }
            target.append(element.toString());
            first = false;
        }
        target.append(")");
    }
}

