/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.servlet.jsp.jstl.core.LoopTagStatus;

public class ForEachLoop<T>
implements Iterable<T> {
    private StateAwareIterator stateAwareIterator;
    private Status status;
    private boolean iterationStarted = false;
    private T currentElement;
    private int count = 1;
    private Integer index;
    private Integer step;
    private Integer begin;
    private Integer end;
    private T element;
    private T nextElement;
    private boolean foundNext = false;

    private ForEachLoop(Iterator<T> iterator) {
        this.stateAwareIterator = new StateAwareIterator(iterator);
        this.status = new Status();
    }

    public static <T> ForEachLoop<T> getInstance(Iterator<T> iterator) {
        return new ForEachLoop<T>(iterator);
    }

    public static <T> ForEachLoop<T> getInstance(Iterable<T> iterable) {
        ForEachLoop<T> loop = new ForEachLoop<T>(iterable.iterator());
        return loop;
    }

    public static <T> ForEachLoop<T> getInstance(T[] array) {
        List<T> arrayList = Arrays.asList(array);
        return ForEachLoop.getInstance(arrayList);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stateAwareIterator;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setStep(int step) {
        this.step = step;
    }

    public class Status
    implements LoopTagStatus {
        public Object getCurrent() {
            return ForEachLoop.this.currentElement;
        }

        public int getIndex() {
            return ForEachLoop.this.index;
        }

        public int getCount() {
            return ForEachLoop.this.count;
        }

        public boolean isFirst() {
            return ForEachLoop.this.count == 1;
        }

        public boolean isLast() {
            return !ForEachLoop.this.stateAwareIterator.hasNext();
        }

        public Integer getBegin() {
            return ForEachLoop.this.begin;
        }

        public Integer getEnd() {
            return ForEachLoop.this.end;
        }

        public Integer getStep() {
            return ForEachLoop.this.step;
        }
    }

    public class StateAwareIterator
    implements Iterator<T> {
        private Iterator<T> iterator;

        public StateAwareIterator(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            try {
                ForEachLoop.this.nextElement = this.next();
                if (ForEachLoop.this.end != null && ForEachLoop.this.index > ForEachLoop.this.end) {
                    ForEachLoop.this.foundNext = false;
                    return false;
                }
                ForEachLoop.this.foundNext = true;
                return true;
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }

        @Override
        public T next() {
            if (ForEachLoop.this.foundNext) {
                ForEachLoop.this.foundNext = false;
                ForEachLoop.this.currentElement = ForEachLoop.this.nextElement;
                return ForEachLoop.this.nextElement;
            }
            if (!ForEachLoop.this.iterationStarted) {
                this.iterateToBegin();
                ForEachLoop.this.iterationStarted = true;
            } else {
                this.iterateByStep();
            }
            ForEachLoop.this.currentElement = ForEachLoop.this.element;
            return ForEachLoop.this.currentElement;
        }

        private void iterateToBegin() {
            int numberOfAdditionalIterations = ForEachLoop.this.begin == null ? 0 : ForEachLoop.this.begin;
            ForEachLoop.this.element = this.iterator.next();
            ForEachLoop.this.index = 0;
            for (int i = 0; i < numberOfAdditionalIterations; ++i) {
                ForEachLoop.this.element = this.iterator.next();
                ForEachLoop.this.index = ForEachLoop.this.index + 1;
            }
        }

        private void iterateByStep() {
            int realStep = ForEachLoop.this.step == null ? 1 : ForEachLoop.this.step;
            for (int i = 0; i < realStep; ++i) {
                ForEachLoop.this.element = this.iterator.next();
                ForEachLoop.this.index = ForEachLoop.this.index + 1;
            }
            ForEachLoop.this.count = ForEachLoop.this.count + 1;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

