/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.seam;

import java.io.IOException;
import java.text.SimpleDateFormat;
import javax.faces.context.FacesContext;
import org.jboss.seam.contexts.Contexts;
import yarfraw.core.datamodel.ChannelFeed;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.ItemEntry;
import yarfraw.core.datamodel.Person;
import yarfraw.core.datamodel.Text;

public class UIEntry
extends org.jboss.seam.rss.ui.UIEntry {
    private static final String COMPONENT_TYPE = UIEntry.class.getName();
    protected static final String RSS20_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss Z";
    private FeedFormat feedFormat;

    public String getFamily() {
        return COMPONENT_TYPE;
    }

    private Text makeText(String textString) {
        Text text = new Text(this.getTextFormat());
        text.setText(textString);
        return text;
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        ChannelFeed channelFeed = (ChannelFeed)Contexts.getEventContext().get("theFeed");
        ItemEntry itemEntry = new ItemEntry();
        itemEntry.setUid(this.getUid());
        itemEntry.setTitle(this.makeText(this.getTitle()));
        itemEntry.addLink(new String[]{this.getLink()});
        String author = this.getAuthor();
        if (author != null) {
            Person authorPerson = new Person();
            authorPerson.setName(author);
            itemEntry.addAuthorOrCreator(new Person[]{authorPerson});
        }
        itemEntry.setDescriptionOrSummary(this.makeText(this.getSummary()));
        if (this.getUpdated() != null) {
            itemEntry.setUpdatedDate(this.getUpdated(), new SimpleDateFormat(this.getFeedDateFormat()));
        }
        if (this.getPublished() != null) {
            itemEntry.setPubDate(this.getPublished(), new SimpleDateFormat(this.getFeedDateFormat()));
        }
        channelFeed.addItem(new ItemEntry[]{itemEntry});
    }

    public FeedFormat getFeedFormat() {
        return (FeedFormat)this.valueOf("feedFormat", this.feedFormat);
    }

    public void setFeedFormat(FeedFormat feedFormat) {
        this.feedFormat = feedFormat;
    }

    public String getFeedDateFormat() {
        if (FeedFormat.RSS20.equals((Object)this.getFeedFormat())) {
            return RSS20_DATE_FORMAT;
        }
        return "yyyy-MM-dd'T'HH:mm:ss'Z'";
    }
}

