/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.seam.NuxeoSeamHotReloader;
import org.nuxeo.runtime.service.TimestampedService;

@Name(value="typesTool")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class TypesTool
implements Serializable {
    private static final long serialVersionUID = -5037578301250616973L;
    protected static final Log log = LogFactory.getLog(TypesTool.class);
    private static final int COLUMN_SIZE = 4;
    @In(create=true)
    protected transient TypeManager typeManager;
    @In(create=true)
    protected NuxeoSeamHotReloader seamReload;
    protected Map<String, List<List<Type>>> typesMap;
    protected Long typesMapTimestamp;
    protected Type selectedType;
    @In(create=true)
    protected transient NavigationContext navigationContext;

    @Observer(value={"contentRootSelectionChanged", "documentSelectionChanged", "domainSelectionChanged", "localConfigurationChanged"}, create=false)
    @BypassInterceptors
    public void resetTypesList() {
        this.typesMap = null;
        this.typesMapTimestamp = null;
    }

    public void populateTypesList() {
        boolean set = false;
        DocumentModel model = this.getCurrentItem();
        if (model != null) {
            this.typesMap = this.getOrganizedTypeMapForDocumentType(model.getType());
            set = true;
        }
        if (!set) {
            this.typesMap = new HashMap<String, List<List<Type>>>();
        }
        this.typesMapTimestamp = this.typeManager.getLastModified();
    }

    public Map<String, List<List<Type>>> getOrganizedTypeMapForDocumentType(String type) {
        Map<String, List<Type>> docTypesMap = this.typeManager.getTypeMapForDocumentType(type, this.getConfigurationDocument());
        docTypesMap = this.filterTypeMap(docTypesMap);
        return this.organizeType(docTypesMap);
    }

    protected DocumentModel getConfigurationDocument() {
        return this.navigationContext.getCurrentDocument();
    }

    protected Map<String, List<Type>> filterTypeMap(Map<String, List<Type>> docTypeMap) {
        return docTypeMap;
    }

    protected Map<String, List<List<Type>>> organizeType(Map<String, List<Type>> types) {
        HashMap<String, List<List<Type>>> newTypesMap = new HashMap<String, List<List<Type>>>();
        Set<Map.Entry<String, List<Type>>> typeEntrySet = types.entrySet();
        for (Map.Entry<String, List<Type>> set : typeEntrySet) {
            List<Type> typeList = set.getValue();
            ArrayList newList = new ArrayList();
            int index = 0;
            newList.add(index, new ArrayList());
            for (Type type : typeList) {
                ArrayList<Type> currentList = (ArrayList<Type>)newList.get(index);
                if (currentList == null) {
                    currentList = new ArrayList<Type>();
                    newList.add(index, currentList);
                }
                currentList.add(type);
                if (currentList.size() % 4 != 0) continue;
                newList.add(++index, new ArrayList());
            }
            newTypesMap.put(set.getKey(), newList);
        }
        return newTypesMap;
    }

    public Type getSelectedType() {
        if (this.selectedType != null) {
            log.debug((Object)("Returning selected type with id: " + this.selectedType.getId()));
        }
        return this.selectedType;
    }

    public void setSelectedType(Type type) {
        if (this.typesMap == null) {
            this.populateTypesList();
        }
        this.selectedType = type;
    }

    @Factory(value="typesMap", scope=ScopeType.EVENT)
    public Map<String, List<List<Type>>> getTypesList() {
        if (this.typesMap == null || this.seamReload.isDevModeSet() && this.seamReload.shouldResetCache((TimestampedService)this.typeManager, this.typesMapTimestamp)) {
            this.populateTypesList();
        }
        this.selectedType = null;
        return this.typesMap;
    }

    public void setTypesList(Map<String, List<List<Type>>> typesList) {
        this.typesMap = typesList;
    }

    public Type getType(String typeName) {
        return this.typeManager.getType(typeName);
    }

    public boolean hasType(String typeName) {
        return this.typeManager.hasType(typeName);
    }

    protected DocumentModel getCurrentItem() {
        return this.navigationContext.getCurrentDocument();
    }
}

