/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.vfs.zip;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;

final class ZipNode {
    private Map<String, ZipNode> children;
    private String name;
    private ZipEntry zipEntry;
    private boolean directory;

    public ZipNode(String name) {
        this.name = name;
    }

    public ZipNode getOrCreateChild(String name) {
        String lcName;
        ZipNode node;
        this.setDirectory(true);
        if (this.children == null) {
            this.children = new LinkedHashMap<String, ZipNode>();
        }
        if ((node = this.children.get(lcName = name.toLowerCase())) == null) {
            node = new ZipNode(name);
            this.children.put(lcName, node);
        }
        return node;
    }

    public ZipNode getChild(String name) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(name.toLowerCase());
    }

    public String getName() {
        return this.name;
    }

    public Iterable<ZipNode> listChildren() {
        if (this.children == null) {
            return Collections.emptySet();
        }
        return this.children.values();
    }

    private void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public void setZipEntry(ZipEntry zipEntry) {
        this.zipEntry = zipEntry;
        this.setDirectory(zipEntry.isDirectory());
    }

    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    public String toString() {
        return "ZipNode[" + this.name + ", " + this.zipEntry.getName() + "]";
    }
}

