/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.content.adapter;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.diff.content.ContentDiffAdapter;
import org.nuxeo.ecm.diff.content.ContentDiffException;
import org.nuxeo.ecm.diff.content.adapter.ContentDiffAdapterFactory;
import org.nuxeo.ecm.diff.content.adapter.ContentDiffAdapterFactoryDescriptor;
import org.nuxeo.ecm.diff.content.adapter.ContentDiffAdapterManager;
import org.nuxeo.ecm.diff.content.adapter.HtmlContentDiffer;
import org.nuxeo.ecm.diff.content.adapter.MimeTypeContentDiffer;
import org.nuxeo.ecm.diff.content.adapter.MimeTypeContentDifferDescriptor;
import org.nuxeo.ecm.diff.content.adapter.factories.BlobHolderContentDiffAdapterFactory;
import org.nuxeo.ecm.diff.content.adapter.factories.FileBasedContentDiffAdapterFactory;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ContentDiffAdapterManagerComponent
extends DefaultComponent
implements ContentDiffAdapterManager {
    public static final String ADAPTER_FACTORY_EP = "adapterFactory";
    public static final String MIME_TYPE_CONTENT_DIFFER_EP = "mimeTypeContentDiffer";
    private static final Log log = LogFactory.getLog(ContentDiffAdapterManagerComponent.class);
    protected Map<String, ContentDiffAdapterFactory> factoryRegistry = new HashMap<String, ContentDiffAdapterFactory>();
    protected Map<String, MimeTypeContentDiffer> contentDifferFactory = new HashMap<String, MimeTypeContentDiffer>();
    protected Map<String, MimeTypeContentDiffer> contentDifferFactoryByName = new HashMap<String, MimeTypeContentDiffer>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (ADAPTER_FACTORY_EP.equals(extensionPoint)) {
            ContentDiffAdapterFactoryDescriptor desc = (ContentDiffAdapterFactoryDescriptor)contribution;
            if (desc.isEnabled()) {
                ContentDiffAdapterFactory factory = desc.getNewInstance();
                if (factory != null) {
                    this.factoryRegistry.put(desc.getTypeName(), factory);
                }
            } else {
                this.factoryRegistry.remove(desc.getTypeName());
            }
        } else if (MIME_TYPE_CONTENT_DIFFER_EP.equals(extensionPoint)) {
            MimeTypeContentDifferDescriptor desc = (MimeTypeContentDifferDescriptor)contribution;
            try {
                MimeTypeContentDiffer contentDiffer = desc.getKlass().newInstance();
                this.contentDifferFactory.put(desc.getPattern(), contentDiffer);
                String name = desc.getName();
                if (StringUtils.isNotBlank((String)name)) {
                    this.contentDifferFactoryByName.put(name, contentDiffer);
                }
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    @Override
    public boolean hasAdapter(DocumentModel doc) {
        if (doc == null) {
            return false;
        }
        String docType = doc.getType();
        if (this.factoryRegistry.containsKey(docType)) {
            return true;
        }
        return doc.hasSchema("file") || doc.hasSchema("files");
    }

    @Override
    public ContentDiffAdapter getAdapter(DocumentModel doc) {
        if (doc == null) {
            return null;
        }
        String docType = doc.getType();
        log.debug((Object)("Looking for ContentDiffAdapter for type " + docType));
        if (this.factoryRegistry.containsKey(docType)) {
            log.debug((Object)"Dedicated ContentDiffAdapter factory found");
            return this.factoryRegistry.get(docType).getAdapter(doc);
        }
        if (doc.isFolder()) {
            return null;
        }
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh != null) {
            log.debug((Object)"Using Blob Holder based ContentDiffAdapter factory");
            BlobHolderContentDiffAdapterFactory factory = new BlobHolderContentDiffAdapterFactory();
            return factory.getAdapter(doc);
        }
        if (doc.hasSchema("file") || doc.hasSchema("files")) {
            log.debug((Object)"Using default file based ContentDiffAdapter factory");
            FileBasedContentDiffAdapterFactory factory = new FileBasedContentDiffAdapterFactory();
            return factory.getAdapter(doc);
        }
        return null;
    }

    @Override
    public MimeTypeContentDiffer getContentDiffer(String mimeType) {
        for (Map.Entry<String, MimeTypeContentDiffer> entry : this.contentDifferFactory.entrySet()) {
            if (!mimeType.matches(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public MimeTypeContentDiffer getContentDifferForName(String name) {
        for (Map.Entry<String, MimeTypeContentDiffer> entry : this.contentDifferFactoryByName.entrySet()) {
            if (!name.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public HtmlContentDiffer getHtmlContentDiffer() throws ContentDiffException {
        MimeTypeContentDiffer htmlContentDiffer = this.contentDifferFactory.get("text/html");
        if (htmlContentDiffer == null || !(htmlContentDiffer instanceof HtmlContentDiffer)) {
            throw new ContentDiffException("No content differ of type HtmlContentDiffer found for the 'text/html' mime-type. Please check the 'mimeTypeContentDiffer' contributions.");
        }
        return (HtmlContentDiffer)htmlContentDiffer;
    }
}

