/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.YarfrawException;
import yarfraw.io.AbstractBaseIO;
import yarfraw.utils.FeedFormatDetector;

abstract class AbstractBaseFeedParser
extends AbstractBaseIO {
    protected HttpURL _httpUrl = null;
    protected HttpClientParams _httpClientParams = null;
    protected GetMethod _getMethod = null;

    public AbstractBaseFeedParser(File file, FeedFormat format) {
        super(file, format);
    }

    public AbstractBaseFeedParser(String pathName, FeedFormat format) {
        super(new File(pathName), format);
    }

    public AbstractBaseFeedParser(URI uri, FeedFormat format) {
        super(new File(uri), format);
    }

    public AbstractBaseFeedParser(File file) {
        super(file);
    }

    public AbstractBaseFeedParser(String pathName) {
        this(new File(pathName));
    }

    public AbstractBaseFeedParser(URI uri) {
        this(new File(uri));
    }

    public AbstractBaseFeedParser(HttpURL httpUrl) throws YarfrawException, IOException {
        this(httpUrl, null);
    }

    public AbstractBaseFeedParser(HttpURL httpUrl, HttpClientParams params) throws YarfrawException, IOException {
        this._httpUrl = httpUrl;
        this._httpClientParams = params;
        this._format = FeedFormatDetector.getFormat(this.getStream());
    }

    public AbstractBaseFeedParser(GetMethod getMethod) throws YarfrawException, IOException {
        this._getMethod = getMethod;
        this._format = FeedFormatDetector.getFormat(this.getStream());
    }

    public HttpClientParams getHttpClientParams() {
        return this._httpClientParams;
    }

    public void setHttpClientParams(HttpClientParams httpClientParams) {
        this._httpClientParams = httpClientParams;
    }

    public GetMethod getGetMethod() {
        return this._getMethod;
    }

    public boolean isRemoteRead() {
        return this._httpUrl != null || this._getMethod != null;
    }

    protected InputStream getStream() throws IOException {
        HttpClient client;
        GetMethod get;
        if (this.isRemoteRead()) {
            get = this.getGetMethod();
            if (get == null) {
                get = new GetMethod(this._httpUrl.toString());
                get.setFollowRedirects(true);
            }
            client = new HttpClient();
            if (this._httpClientParams != null) {
                client.setParams(this._httpClientParams);
            }
        } else {
            return new FileInputStream(this._file);
        }
        client.executeMethod((HttpMethod)get);
        InputStream stream = get.getResponseBodyAsStream();
        return stream;
    }
}

