/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.util;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.jboss.seam.navigation.Page;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.ui.util.UrlBuilder;

public class ViewUrlBuilder
extends UrlBuilder {
    private Page page;
    private String viewId;

    public ViewUrlBuilder(String viewId, String fragment, boolean urlEncodeParameters) {
        super(fragment, FacesContext.getCurrentInstance().getResponseWriter().getCharacterEncoding(), urlEncodeParameters);
        if (viewId == null) {
            throw new NullPointerException("viewId must not be null");
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String url = facesContext.getApplication().getViewHandler().getActionURL(facesContext, viewId);
        url = Pages.instance().encodeScheme(viewId, facesContext, url);
        this.setUrl(url);
        this.page = Pages.instance().getPage(viewId);
        this.viewId = viewId;
    }

    public ViewUrlBuilder(String viewId, String fragment) {
        this(viewId, fragment, false);
    }

    @Override
    public void addParameter(UIParameter parameter) throws UnsupportedEncodingException {
        String name = parameter.getName();
        if (!(parameter.getValue() == null || name.equals(this.page.getConversationIdParameter().getParameterName()) && this.getParameters().containsKey(name))) {
            super.addParameter(parameter);
        }
    }

    @Override
    public String getEncodedUrl() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return facesContext.getApplication().getViewHandler().getBookmarkableURL(facesContext, this.viewId, this.getParametersAsMap(this.getParameters()), false);
    }

    private Map<String, List<String>> getParametersAsMap(Map<String, String> params) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(entry.getValue());
            parameters.put(entry.getKey(), list);
        }
        return parameters;
    }
}

