/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.bulkedit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;

public class BulkEditHelper {
    private static final Log log = LogFactory.getLog(BulkEditHelper.class);

    private BulkEditHelper() {
    }

    public static List<String> getCommonLayouts(TypeManager typeManager, List<DocumentModel> docs) {
        return BulkEditHelper.getCommonLayouts(typeManager, docs, "edit");
    }

    public static List<String> getCommonLayouts(TypeManager typeManager, List<DocumentModel> docs, String mode) {
        ArrayList<String> layouts = null;
        for (DocumentModel doc : docs) {
            Type type = typeManager.getType(doc.getType());
            List<String> typeLayouts = Arrays.asList(type.getLayouts(mode));
            if (layouts == null) {
                layouts = new ArrayList<String>();
                layouts.addAll(typeLayouts);
                continue;
            }
            layouts.retainAll(typeLayouts);
        }
        return layouts;
    }

    public static List<String> getCommonSchemas(List<DocumentModel> docs) {
        ArrayList<String> schemas = null;
        for (DocumentModel doc : docs) {
            List<String> docSchemas = Arrays.asList(doc.getSchemas());
            if (schemas == null) {
                schemas = new ArrayList<String>();
                schemas.addAll(docSchemas);
                continue;
            }
            schemas.retainAll(docSchemas);
        }
        return schemas;
    }
}

