/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.common.utils.UserAgentMatcher;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.TabActionsSelection;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.webapp.action.ActionContextProvider;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

@Name(value="webActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class WebActionsBean
implements WebActions,
Serializable {
    private static final long serialVersionUID = 1959221536502251848L;
    private static final Log log = LogFactory.getLog(WebActionsBean.class);
    @In(create=true, required=false)
    protected transient ActionManager actionManager;
    @In(create=true, required=false)
    protected transient ActionContextProvider actionContextProvider;
    @In(create=true, required=false)
    protected transient NavigationContext navigationContext;
    protected List<Action> tabsActionsList;
    protected String subTabsCategory;
    protected List<Action> subTabsActionsList;
    protected TabActionsSelection currentTabActions = new TabActionsSelection();

    public List<Action> getDocumentActions(DocumentModel document, String category, boolean removeFiltered, boolean postFilter) {
        ActionContext context = postFilter ? null : this.createActionContext(document);
        return this.getActions(context, category, removeFiltered, postFilter);
    }

    public Action getDocumentAction(DocumentModel document, String actionId, boolean removeFiltered, boolean postFilter) {
        ActionContext context = postFilter ? null : this.createActionContext(document);
        return this.getAction(context, actionId, removeFiltered, postFilter);
    }

    public List<Action> getActions(ActionContext context, String category, boolean removeFiltered, boolean postFilter) {
        String[] split;
        ArrayList<Action> list = new ArrayList<Action>();
        ArrayList<String> categories = new ArrayList<String>();
        if (category != null && (split = category.split(",|\\s")) != null) {
            for (String item : split) {
                if (StringUtils.isBlank((String)item)) continue;
                categories.add(item.trim());
            }
        }
        for (String cat : categories) {
            List actions = postFilter ? this.actionManager.getAllActions(cat) : this.actionManager.getActions(cat, context, removeFiltered);
            if (actions == null) continue;
            list.addAll(actions);
        }
        return list;
    }

    public Action getAction(ActionContext context, String actionId, boolean removeFiltered, boolean postFilter) {
        if (postFilter) {
            return this.actionManager.getAction(actionId);
        }
        return this.actionManager.getAction(actionId, context, removeFiltered);
    }

    public boolean isAvailableForDocument(DocumentModel document, Action action) {
        return this.isAvailable(this.createActionContext(document), action);
    }

    public boolean isAvailable(ActionContext context, Action action) {
        if (action == null) {
            return false;
        }
        if (action.isFiltered()) {
            return action.getAvailable();
        }
        return this.actionManager.checkFilters(action, context);
    }

    public List<Action> getActionsList(String category, ActionContext context, boolean removeFiltered) {
        return this.getActions(context, category, removeFiltered, false);
    }

    public List<Action> getActionsList(String category, Boolean removeFiltered) {
        return this.getActions(this.createActionContext(), category, removeFiltered, false);
    }

    public List<Action> getActionsList(String category, ActionContext context) {
        return this.getActions(context, category, true, false);
    }

    public List<Action> getActionsListForDocument(String category, DocumentModel document, boolean removeFiltered) {
        return this.getActions(this.createActionContext(document), category, removeFiltered, false);
    }

    public List<Action> getActionsList(String category) {
        return this.getActions(this.createActionContext(), category, true, false);
    }

    public List<Action> getAllActions(String category) {
        return this.actionManager.getAllActions(category);
    }

    protected ActionContext createActionContext() {
        return this.actionContextProvider.createActionContext();
    }

    protected ActionContext createActionContext(DocumentModel document) {
        return this.actionContextProvider.createActionContext(document);
    }

    public Action getAction(String actionId, boolean removeFiltered) {
        return this.getAction(this.createActionContext(), actionId, removeFiltered, false);
    }

    public Action getActionForDocument(String actionId, DocumentModel document, boolean removeFiltered) {
        return this.getAction(this.createActionContext(document), actionId, removeFiltered, false);
    }

    public Action getAction(String actionId, ActionContext context, boolean removeFiltered) {
        return this.getAction(context, actionId, removeFiltered, false);
    }

    public boolean checkFilter(String filterId) {
        return this.actionManager.checkFilter(filterId, this.createActionContext());
    }

    protected Action getDefaultTab(String category) {
        if ("VIEW_ACTION_LIST".equals(category)) {
            if (this.getTabsList() == null) {
                return null;
            }
            try {
                return this.tabsActionsList.get(0);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        if (this.subTabsCategory != null && this.subTabsCategory.equals(category)) {
            if (this.getSubTabsList() == null) {
                return null;
            }
            try {
                return this.subTabsActionsList.get(0);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        List<Action> actions = this.getActionsList(category, this.createActionContext());
        if (actions != null && actions.size() > 0) {
            Action action = actions.get(0);
            this.setCurrentTabAction(category, action);
            return action;
        }
        return null;
    }

    public Action getCurrentTabAction(String category) {
        Action action = this.currentTabActions.getCurrentTabAction(category);
        if (action == null) {
            action = this.getDefaultTab(category);
        }
        return action;
    }

    public void setCurrentTabAction(String category, Action tabAction) {
        this.currentTabActions.setCurrentTabAction(category, tabAction);
        if ("VIEW_ACTION_LIST".equals(category)) {
            this.resetSubTabs();
        }
    }

    public Action getCurrentSubTabAction(String parentActionId) {
        return this.getCurrentTabAction(TabActionsSelection.getSubTabCategory((String)parentActionId));
    }

    public String getCurrentTabId(String category) {
        Action action = this.getCurrentTabAction(category);
        if (action != null) {
            return action.getId();
        }
        return null;
    }

    public boolean hasCurrentTabId(String category) {
        return this.currentTabActions.getCurrentTabAction(category) != null;
    }

    public void setCurrentTabId(String category, String tabId, String ... subTabIds) {
        this.currentTabActions.setCurrentTabId(this.actionManager, this.createActionContext(), category, tabId, subTabIds);
        if ("VIEW_ACTION_LIST".equals(category)) {
            this.resetSubTabs();
        }
    }

    public String getCurrentTabIds() {
        return this.currentTabActions.getCurrentTabIds();
    }

    public void setCurrentTabIds(String tabIds) {
        this.currentTabActions.setCurrentTabIds(this.actionManager, this.createActionContext(), tabIds);
        this.resetSubTabs();
    }

    public void resetCurrentTabs() {
        this.currentTabActions.resetCurrentTabs();
    }

    public void resetCurrentTabs(String category) {
        this.currentTabActions.resetCurrentTabs(category);
    }

    public void resetCurrentTab() {
        this.resetCurrentTabs("VIEW_ACTION_LIST");
    }

    protected void resetSubTabs() {
        this.subTabsCategory = null;
        this.subTabsActionsList = null;
        Contexts.getEventContext().remove("subTabsActionsList");
        Contexts.getEventContext().remove("currentSubTabAction");
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged", "locationSelectionChanged"}, create=false)
    @BypassInterceptors
    public void resetTabList() {
        this.tabsActionsList = null;
        this.resetSubTabs();
        this.resetCurrentTab();
        Contexts.getEventContext().remove("tabsActionsList");
        Contexts.getEventContext().remove("currentTabAction");
    }

    @Factory(value="tabsActionsList", scope=ScopeType.EVENT)
    public List<Action> getTabsList() {
        if (this.tabsActionsList == null) {
            this.tabsActionsList = this.getActionsList("VIEW_ACTION_LIST");
        }
        return this.tabsActionsList;
    }

    @Factory(value="subTabsActionsList", scope=ScopeType.EVENT)
    public List<Action> getSubTabsList() {
        String currentTabId;
        if (this.subTabsActionsList == null && (currentTabId = this.getCurrentTabId()) != null) {
            this.subTabsCategory = TabActionsSelection.getSubTabCategory((String)currentTabId);
            this.subTabsActionsList = this.getActionsList(this.subTabsCategory);
        }
        return this.subTabsActionsList;
    }

    @Factory(value="currentTabAction", scope=ScopeType.EVENT)
    public Action getCurrentTabAction() {
        return this.getCurrentTabAction("VIEW_ACTION_LIST");
    }

    public void setCurrentTabAction(Action currentTabAction) {
        this.setCurrentTabAction("VIEW_ACTION_LIST", currentTabAction);
    }

    @Factory(value="currentSubTabAction", scope=ScopeType.EVENT)
    public Action getCurrentSubTabAction() {
        Action action = this.getCurrentTabAction();
        if (action != null) {
            return this.getCurrentTabAction(TabActionsSelection.getSubTabCategory((String)action.getId()));
        }
        return null;
    }

    public void setCurrentSubTabAction(Action tabAction) {
        if (tabAction != null) {
            String[] categories = tabAction.getCategories();
            if (categories == null || categories.length == 0) {
                log.error((Object)("Cannot set subtab with id '" + tabAction.getId() + "' as this action does not hold any category"));
                return;
            }
            if (categories.length != 1) {
                log.error((Object)("Setting subtab with id '" + tabAction.getId() + "' with category '" + categories[0] + "': use webActions#setCurrentTabAction(action, category) to specify another category"));
            }
            this.setCurrentTabAction(categories[0], tabAction);
        }
    }

    public String getCurrentTabId() {
        Action currentTab = this.getCurrentTabAction();
        if (currentTab != null) {
            return currentTab.getId();
        }
        return null;
    }

    public void setCurrentTabId(String tabId) {
        if (tabId != null) {
            this.setCurrentTabId("VIEW_ACTION_LIST", tabId, new String[0]);
        }
    }

    public String getCurrentSubTabId() {
        Action currentSubTab = this.getCurrentSubTabAction();
        if (currentSubTab != null) {
            return currentSubTab.getId();
        }
        return null;
    }

    public void setCurrentSubTabId(String tabId) {
        Action action;
        if (tabId != null && (action = this.getCurrentTabAction()) != null) {
            this.setCurrentTabId(TabActionsSelection.getSubTabCategory((String)action.getId()), tabId, new String[0]);
        }
    }

    public String setCurrentTabAndNavigate(String currentTabActionId) {
        return this.setCurrentTabAndNavigate(this.navigationContext.getCurrentDocument(), currentTabActionId);
    }

    public String setCurrentTabAndNavigate(DocumentModel document, String currentTabActionId) {
        String viewId = null;
        try {
            viewId = this.navigationContext.navigateToDocument(document);
        }
        catch (NuxeoException e) {
            log.error((Object)("Failed to navigate to " + document), (Throwable)e);
        }
        this.getTabsList();
        this.setCurrentTabId(currentTabActionId);
        return viewId;
    }

    @Factory(value="useAjaxTabs", scope=ScopeType.SESSION)
    public boolean useAjaxTabs() {
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        if (configurationService.isBooleanPropertyTrue("nuxeo.jsf.useAjaxTabs")) {
            return this.canUseAjaxTabs();
        }
        return false;
    }

    @Factory(value="canUseAjaxTabs", scope=ScopeType.SESSION)
    public boolean canUseAjaxTabs() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext econtext = context.getExternalContext();
        HttpServletRequest request = (HttpServletRequest)econtext.getRequest();
        String ua = request.getHeader("User-Agent");
        return UserAgentMatcher.isHistoryPushStateSupported((String)ua);
    }

    @Factory(value="removeActionOptims", scope=ScopeType.SESSION)
    public boolean removeActionOptims() {
        ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
        return cs.isBooleanPropertyTrue("nuxeo.jsf.actions.removeActionOptims");
    }

    @Observer(value={"flush"}, create=false)
    @BypassInterceptors
    public void onHotReloadFlush() {
        Context seamContext = Contexts.getSessionContext();
        seamContext.remove("useAjaxTabs");
        seamContext.remove("canUseAjaxTabs");
    }
}

