/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.jsf.JSFActionContext;
import org.nuxeo.ecm.platform.actions.seam.SeamActionContext;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.SeamContextHelper;

@Name(value="actionContextProvider")
@Scope(value=ScopeType.STATELESS)
public class ActionContextProvider
implements Serializable {
    private static final long serialVersionUID = 675765759871L;
    @In(create=true)
    private transient NavigationContext navigationContext;
    @In(create=true)
    private transient NuxeoPrincipal currentNuxeoPrincipal;
    @In(create=true, required=false)
    private transient CoreSession documentManager;

    @Factory(value="currentActionContext", scope=ScopeType.EVENT)
    public ActionContext createActionContext() {
        return this.createActionContext(this.navigationContext.getCurrentDocument());
    }

    public ActionContext createActionContext(DocumentModel document) {
        FacesContext faces = FacesContext.getCurrentInstance();
        Object ctx = faces == null ? new SeamActionContext() : new JSFActionContext(faces);
        ctx.setCurrentDocument(document);
        ctx.setDocumentManager(this.documentManager);
        ctx.setCurrentPrincipal(this.currentNuxeoPrincipal);
        ctx.putLocalVariable("SeamContext", (Object)new SeamContextHelper());
        return ctx;
    }
}

