/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;

public enum ImageType {
    GIF("gif"){

        @Override
        public BufferedImage createImage(int width, int height) {
            return ImageType.createBitmaskImage(width, height);
        }
    }
    ,
    PNG("png"){

        @Override
        public BufferedImage createImage(int width, int height) {
            return ImageType.createARGBImage(width, height);
        }
    }
    ,
    PNG8("png"){

        @Override
        public BufferedImage createImage(int width, int height) {
            return new BufferedImage(width, height, 13, SAFE_WEB_COLORS_MODEL);
        }
    }
    ,
    JPEG("jpeg"){

        @Override
        public BufferedImage createImage(int width, int height) {
            return new BufferedImage(width, height, 1);
        }
    };

    protected static final IndexColorModel SAFE_WEB_COLORS_MODEL;
    private String formatName;
    private String mimeType;

    private ImageType(String formatName) {
        this.formatName = formatName;
        this.mimeType = "image/" + formatName;
    }

    private static BufferedImage createARGBImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    private static BufferedImage createBitmaskImage(int width, int height) {
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 2, 0);
        WritableRaster raster = ((ColorModel)colorModel).createCompatibleWritableRaster(width, height);
        return new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
    }

    public abstract BufferedImage createImage(int var1, int var2);

    public BufferedImage createImage(Dimension dimension) {
        return this.createImage(dimension.width, dimension.height);
    }

    public String getFormatName() {
        return this.formatName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    static {
        byte[] webLevels = new byte[]{0, 51, 102, -103, -52, -1};
        int colorsNumber = webLevels.length * webLevels.length * webLevels.length;
        byte[] r = new byte[colorsNumber];
        byte[] g = new byte[colorsNumber];
        byte[] b = new byte[colorsNumber];
        r[0] = 0;
        g[0] = 0;
        b[0] = 0;
        for (int i = 0; i < webLevels.length; ++i) {
            for (int j = 0; j < webLevels.length; ++j) {
                for (int k = 0; k < webLevels.length; ++k) {
                    int colorNum = i * webLevels.length * webLevels.length + j * webLevels.length + k;
                    r[colorNum] = webLevels[i];
                    g[colorNum] = webLevels[j];
                    b[colorNum] = webLevels[k];
                }
            }
        }
        SAFE_WEB_COLORS_MODEL = new IndexColorModel(8, colorsNumber, r, g, b, 0);
    }
}

