/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf.ui;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.jboss.seam.pdf.ITextUtils;
import org.jboss.seam.pdf.ui.UIRectangle;
import org.jboss.seam.ui.graphicImage.ImageTransform;

public class UIImage
extends UIRectangle {
    public static final String COMPONENT_TYPE = "org.jboss.seam.pdf.ui.UIImage";
    com.lowagie.text.Image image;
    Object value;
    float rotation;
    float height;
    float width;
    String alignment;
    String alt;
    Float indentationLeft;
    Float indentationRight;
    Float spacingBefore;
    Float spacingAfter;
    Float widthPercentage;
    Float initialRotation;
    String dpi;
    String scalePercent;
    String scaleToFit;
    Boolean wrap;
    Boolean underlying;
    Image imageData;

    public void setValue(Object value) {
        this.value = value;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }

    public void setAlt(String alt) {
        this.alt = alt;
    }

    public void setWrap(Boolean wrap) {
        this.wrap = wrap;
    }

    public void setUnderlying(Boolean underlying) {
        this.underlying = underlying;
    }

    public void setDpi(String dpi) {
        this.dpi = dpi;
    }

    public void setIndentationLeft(Float indentationLeft) {
        this.indentationLeft = indentationLeft;
    }

    public void setIndentationRight(Float indentationRight) {
        this.indentationRight = indentationRight;
    }

    public void setInitialRotation(Float initialRotation) {
        this.initialRotation = initialRotation;
    }

    public void setSpacingAfter(Float spacingAfter) {
        this.spacingAfter = spacingAfter;
    }

    public void setSpacingBefore(Float spacingBefore) {
        this.spacingBefore = spacingBefore;
    }

    public void setWidthPercentage(Float widthPercentage) {
        this.widthPercentage = widthPercentage;
    }

    public void setScalePercent(String scalePercent) {
        this.scalePercent = scalePercent;
    }

    public void setScaleToFit(String scaleToFit) {
        this.scaleToFit = scaleToFit;
    }

    @Override
    public Object getITextObject() {
        return this.image;
    }

    @Override
    public void removeITextObject() {
        this.image = null;
    }

    @Override
    public void createITextObject(FacesContext context) throws IOException, DocumentException {
        float[] scale;
        this.value = this.valueBinding(context, "value", this.value);
        org.jboss.seam.ui.graphicImage.Image seamImage = new org.jboss.seam.ui.graphicImage.Image();
        if (this.value instanceof BufferedImage) {
            seamImage.setBufferedImage((BufferedImage)this.value);
        } else {
            seamImage.setInput(this.value);
        }
        for (UIComponent cmp : this.getChildren()) {
            if (!(cmp instanceof ImageTransform)) continue;
            ImageTransform imageTransform = (ImageTransform)cmp;
            imageTransform.applyTransform(seamImage);
        }
        byte[] data = seamImage.getImage();
        this.image = com.lowagie.text.Image.getInstance((byte[])data);
        this.rotation = ((Float)this.valueBinding(context, "rotation", Float.valueOf(this.rotation))).floatValue();
        if (this.rotation != 0.0f) {
            this.image.setRotationDegrees(this.rotation);
        }
        this.height = ((Float)this.valueBinding(context, "height", Float.valueOf(this.height))).floatValue();
        this.width = ((Float)this.valueBinding(context, "width", Float.valueOf(this.width))).floatValue();
        if (this.height > 0.0f || this.width > 0.0f) {
            this.image.scaleAbsolute(this.width, this.height);
        }
        int alignmentValue = 0;
        this.alignment = (String)this.valueBinding(context, "alignment", this.alignment);
        if (this.alignment != null) {
            alignmentValue = ITextUtils.alignmentValue(this.alignment);
        }
        this.wrap = (Boolean)this.valueBinding(context, "wrap", this.wrap);
        if (this.wrap != null && this.wrap.booleanValue()) {
            alignmentValue |= 4;
        }
        this.underlying = (Boolean)this.valueBinding(context, "underlying", this.underlying);
        if (this.underlying != null && this.underlying.booleanValue()) {
            alignmentValue |= 8;
        }
        this.image.setAlignment(alignmentValue);
        this.alt = (String)this.valueBinding(context, "alt", this.alt);
        if (this.alt != null) {
            this.image.setAlt(this.alt);
        }
        this.indentationLeft = (Float)this.valueBinding(context, "indentationLeft", this.indentationLeft);
        if (this.indentationLeft != null) {
            this.image.setIndentationLeft(this.indentationLeft.floatValue());
        }
        this.indentationRight = (Float)this.valueBinding(context, "indentationRight", this.indentationRight);
        if (this.indentationRight != null) {
            this.image.setIndentationRight(this.indentationRight.floatValue());
        }
        this.spacingBefore = (Float)this.valueBinding(context, "spacingBefore", this.spacingBefore);
        if (this.spacingBefore != null) {
            this.image.setSpacingBefore(this.spacingBefore.floatValue());
        }
        this.spacingAfter = (Float)this.valueBinding(context, "spacingAfter", this.spacingAfter);
        if (this.spacingAfter != null) {
            this.image.setSpacingAfter(this.spacingAfter.floatValue());
        }
        this.widthPercentage = (Float)this.valueBinding(context, "widthPercentage", this.widthPercentage);
        if (this.widthPercentage != null) {
            this.image.setWidthPercentage(this.widthPercentage.floatValue());
        }
        this.initialRotation = (Float)this.valueBinding(context, "initialRotation", this.initialRotation);
        if (this.initialRotation != null) {
            this.image.setInitialRotation(this.initialRotation.floatValue());
        }
        this.dpi = (String)this.valueBinding(context, "dpi", this.dpi);
        if (this.dpi != null) {
            int[] dpiValues = ITextUtils.stringToIntArray(this.dpi);
            this.image.setDpi(dpiValues[0], dpiValues[1]);
        }
        this.applyRectangleProperties(context, (Rectangle)this.image);
        this.scaleToFit = (String)this.valueBinding(context, "scaleToFit", this.scaleToFit);
        if (this.scaleToFit != null) {
            scale = ITextUtils.stringToFloatArray(this.scaleToFit);
            if (scale.length == 2) {
                this.image.scaleToFit(scale[0], scale[1]);
            } else {
                throw new RuntimeException("scaleToFit must contain two dimensions");
            }
        }
        this.scalePercent = (String)this.valueBinding(context, "scalePercent", this.scalePercent);
        if (this.scalePercent != null) {
            scale = ITextUtils.stringToFloatArray(this.scalePercent);
            if (scale.length == 1) {
                this.image.scalePercent(scale[0]);
            } else if (scale.length == 2) {
                this.image.scalePercent(scale[0], scale[1]);
            } else {
                throw new RuntimeException("scalePercent must contain one or two scale percentages");
            }
        }
    }

    @Override
    public void handleAdd(Object o) {
        throw new RuntimeException("can't add " + o.getClass().getName() + " to image");
    }
}

