/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.seam.messages;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Locale;
import org.jboss.seam.core.ResourceLoader;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.nuxeo.ecm.webapp.seam.messages.HotReloadResourceBundleControl;

@Scope(value=ScopeType.STATELESS)
@BypassInterceptors
@Name(value="org.jboss.seam.core.resourceLoader")
@Install(precedence=20, debug=false)
public class HotReloadResourceLoader
extends ResourceLoader {
    private static final LogProvider log = Logging.getLogProvider(HotReloadResourceLoader.class);

    public ResourceBundle loadBundle(String bundleName) {
        try {
            HotReloadResourceBundleControl control = HotReloadResourceBundleControl.instance();
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName, Locale.instance(), Thread.currentThread().getContextClassLoader(), control);
            log.debug((Object)("loaded resource bundle: " + bundleName));
            return bundle;
        }
        catch (MissingResourceException mre) {
            log.debug((Object)("resource bundle missing: " + bundleName));
            return null;
        }
    }
}

