/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.w3c.dom.Element;

public class LockingRestlet
extends BaseStatelessNuxeoRestlet {
    public static final String LOCK = "lock";
    public static final String UNLOCK = "unlock";
    public static final String STATUS = "status";
    public static final String STATE = "state";
    public static final String SC_LOCKINFO_LOCKED = "LOCKED";
    public static final String SC_LOCKINFO_NOT_LOCKED = "NOTLOCKED";
    public static final String SC_LOCKED_OK = "OK";
    public static final String SC_ALREADY_LOCKED_KO = "ALREADYLOCKED";
    public static final String SC_ALREADY_LOCKED_OK = "ALREADYLOCKEDBYYOU";
    public static final String SC_UNLOCKED_OK = "OK";
    public static final String SC_ALREADY_UNLOCKED_OK = "NOT LOCKED";

    @Override
    protected void doHandleStatelessRequest(Request req, Response res) {
        Lock lock;
        String repoId = (String)req.getAttributes().get("repo");
        String docid = (String)req.getAttributes().get("docid");
        DOMDocumentFactory domFactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domFactory.createDocument();
        boolean initOk = this.initRepositoryAndTargetDocument(res, repoId, docid);
        if (!initOk) {
            return;
        }
        String cUserName = LockingRestlet.getUserPrincipal(req).getName();
        String action = STATUS;
        if (req.getResourceRef().getSegments().size() > 5) {
            action = ((String)req.getResourceRef().getSegments().get(5)).toLowerCase();
        }
        if (req.getMethod().equals((Object)Method.LOCK)) {
            action = LOCK;
        }
        if (req.getMethod().equals((Object)Method.UNLOCK)) {
            action = UNLOCK;
        }
        String response = "";
        String code = "";
        if (action.equals(LOCK)) {
            try {
                lock = this.session.getLockInfo(this.targetDocRef);
                if (lock == null) {
                    this.session.setLock(this.targetDocRef);
                    this.session.save();
                    response = "lock acquired on document " + docid;
                    code = "OK";
                }
                if (lock.getOwner().equals(cUserName)) {
                    response = "document " + docid + " is already locked by you";
                    code = SC_ALREADY_LOCKED_OK;
                }
                response = "document " + docid + " is already locked by " + lock.getOwner();
                code = SC_ALREADY_LOCKED_KO;
            }
            catch (NuxeoException e) {
                LockingRestlet.handleError(result, res, (Exception)((Object)e));
                return;
            }
        } else if (action.equals(UNLOCK)) {
            try {
                lock = this.session.getLockInfo(this.targetDocRef);
                if (lock == null) {
                    response = "document " + docid + " is not locked";
                    code = SC_ALREADY_UNLOCKED_OK;
                }
                if (lock.getOwner().equals(cUserName)) {
                    this.session.removeLock(this.targetDocRef);
                    this.session.save();
                    response = "document " + docid + " unlocked";
                    code = "OK";
                }
                response = "document " + docid + " is locked by " + lock.getOwner();
                code = SC_ALREADY_LOCKED_KO;
            }
            catch (NuxeoException e) {
                LockingRestlet.handleError(result, res, (Exception)((Object)e));
                return;
            }
        } else if (action.equals(STATUS)) {
            try {
                lock = this.session.getLockInfo(this.targetDocRef);
                response = this.session.getLock(this.targetDocRef);
                if (lock == null) {
                    code = SC_LOCKINFO_NOT_LOCKED;
                }
                code = SC_LOCKINFO_LOCKED;
            }
            catch (NuxeoException e) {
                LockingRestlet.handleError(result, res, (Exception)((Object)e));
                return;
            }
        } else if (action.equals(STATE)) {
            try {
                lock = this.session.getLockInfo(this.targetDocRef);
                if (lock == null) {
                    code = SC_LOCKINFO_NOT_LOCKED;
                    response = "";
                }
                code = SC_LOCKINFO_LOCKED;
                response = lock.getOwner() + '/' + ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)lock.getCreated()));
            }
            catch (NuxeoException e) {
                LockingRestlet.handleError(result, res, (Exception)((Object)e));
                return;
            }
        } else {
            LockingRestlet.handleError(result, res, "Unsupported operation");
            return;
        }
        Element current = result.createElement("document");
        current.setAttribute("code", code);
        current.setAttribute("message", response);
        result.setRootElement((org.dom4j.Element)current);
        res.setEntity(result.asXML(), MediaType.TEXT_XML);
        res.getEntity().setCharacterSet(CharacterSet.UTF_8);
    }
}

