/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.application;

import com.noelios.restlet.TemplateDispatcher;
import com.noelios.restlet.application.ApplicationDispatcher;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.Protocol;

public class ApplicationContext
extends Context {
    private Client warClient;
    private Application application;
    private Context parentContext;

    public ApplicationContext(Application application, Context parentContext, Logger logger) {
        super(ApplicationContext.getLoggerName(application));
        this.application = application;
        this.parentContext = parentContext;
        this.warClient = null;
        this.getAttributes().put("org.restlet.application", application);
    }

    private static String getLoggerName(Application application) {
        String result = application.getClass().getCanonicalName();
        if (result == null) {
            result = "org.restlet.application";
        }
        return result;
    }

    public Uniform getDispatcher() {
        return new TemplateDispatcher(this, new ApplicationDispatcher(this));
    }

    protected Application getApplication() {
        return this.application;
    }

    protected Client getWarClient() {
        if (this.warClient == null) {
            this.warClient = new Client(Protocol.WAR);
        }
        return this.warClient;
    }

    protected void setWarClient(Client warClient) {
        this.warClient = warClient;
    }

    protected Context getParentContext() {
        return this.parentContext;
    }
}

