/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.localconfiguration;

import java.io.Serializable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="localConfigurationActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class LocalConfigurationActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String LOCAL_CONFIGURATION_CHANGED_LABEL = "label.local.configuration.modified";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;

    public void toggleConfigurationForCurrentDocument(String configurationFacet) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument.hasFacet(configurationFacet)) {
            currentDocument.removeFacet(configurationFacet);
        } else {
            currentDocument.addFacet(configurationFacet);
        }
        this.documentManager.saveDocument(currentDocument);
        this.navigationContext.invalidateCurrentDocument();
        this.documentManager.save();
        Events.instance().raiseEvent("localConfigurationChanged", new Object[]{this.navigationContext.getCurrentDocument()});
    }

    public void saveLocalConfiguration() {
        this.documentManager.saveDocument(this.navigationContext.getCurrentDocument());
        this.navigationContext.invalidateCurrentDocument();
        Events.instance().raiseEvent("localConfigurationChanged", new Object[]{this.navigationContext.getCurrentDocument()});
        this.facesMessages.add(StatusMessage.Severity.INFO, this.resourcesAccessor.getMessages().get(LOCAL_CONFIGURATION_CHANGED_LABEL), new Object[0]);
    }
}

