/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.mapping.forward.impl;

import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import yarfraw.core.datamodel.CategorySubject;
import yarfraw.core.datamodel.ChannelFeed;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.Generator;
import yarfraw.core.datamodel.ItemEntry;
import yarfraw.core.datamodel.Link;
import yarfraw.core.datamodel.Person;
import yarfraw.core.datamodel.YarfrawException;
import yarfraw.generated.atom10.elements.DateTimeType;
import yarfraw.generated.atom10.elements.FeedType;
import yarfraw.generated.atom10.elements.GeneratorType;
import yarfraw.generated.atom10.elements.ObjectFactory;
import yarfraw.mapping.forward.ToAtom10Channel;
import yarfraw.mapping.forward.impl.Atom10MappingUtils;
import yarfraw.utils.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToAtom10ChannelImpl
implements ToAtom10Channel {
    private static final Log LOG = LogFactory.getLog(ToAtom10ChannelImpl.class);
    private static ToAtom10Channel _instance = new ToAtom10ChannelImpl();
    private static final ObjectFactory FACTORY = new ObjectFactory();

    public static ToAtom10Channel getInstance() {
        return _instance;
    }

    private ToAtom10ChannelImpl() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JAXBElement<FeedType> execute(ChannelFeed ch) throws YarfrawException {
        ObjectFactory factory = FACTORY;
        FeedType ret = factory.createFeedType();
        List<Object> elementList = ret.getAuthorOrCategoryOrContributor();
        if (ch.getUid() != null) {
            elementList.add(factory.createEntryTypeId(Atom10MappingUtils.toAtomId(ch.getUid())));
        }
        if (ch.getManagingEditorOrAuthorOrPublisher() != null) {
            for (Person person : ch.getManagingEditorOrAuthorOrPublisher()) {
                elementList.add(factory.createFeedTypeAuthor(Atom10MappingUtils.toPersonType(person)));
            }
        }
        if (ch.getCategorySubjects() != null) {
            for (CategorySubject categorySubject : ch.getCategorySubjects()) {
                if (categorySubject == null) continue;
                elementList.add(factory.createFeedTypeCategory(Atom10MappingUtils.toCategoryType(categorySubject)));
            }
        }
        if (ch.getContributors() != null) {
            for (Person person : ch.getContributors()) {
                elementList.add(factory.createFeedTypeContributor(Atom10MappingUtils.toPersonType(person)));
            }
        }
        if (ch.getGenerator() != null) {
            GeneratorType g = factory.createGeneratorType();
            Generator generator = ch.getGenerator();
            g.setUri(generator.getUri());
            g.setValue(generator.getValue());
            g.setVersion(generator.getVersion());
            if (generator.getOtherAttributes() != null) {
                g.getOtherAttributes().putAll(generator.getOtherAttributes());
            }
            g.setBase(generator.getBase());
            g.setLang(generator.getLang());
            elementList.add(factory.createFeedTypeGenerator(g));
        }
        if (ch.getImageOrIcon() != null) {
            elementList.add(factory.createFeedTypeIcon(Atom10MappingUtils.toIcon(ch.getImageOrIcon())));
        }
        if (ch.getUid() != null) {
            elementList.add(factory.createFeedTypeId(Atom10MappingUtils.toAtomId(ch.getUid())));
        }
        if (ch.getLinks() != null) {
            for (Link link : ch.getLinks()) {
                elementList.add(factory.createFeedTypeLink(Atom10MappingUtils.toLink(link)));
            }
        }
        if (ch.getLogo() != null) {
            elementList.add(factory.createFeedTypeIcon(Atom10MappingUtils.toIcon(ch.getLogo())));
        }
        if (ch.getRights() != null) {
            elementList.add(factory.createFeedTypeRights(Atom10MappingUtils.toTextType(ch.getRights())));
        }
        if (ch.getDescriptionOrSubtitle() != null) {
            elementList.add(factory.createFeedTypeSubtitle(Atom10MappingUtils.toTextType(ch.getDescriptionOrSubtitle())));
        }
        if (ch.getTitle() != null) {
            elementList.add(factory.createFeedTypeTitle(Atom10MappingUtils.toTextType(ch.getTitle())));
        }
        if (ch.getLastBuildOrUpdatedDate() != null) {
            void var6_17;
            DateTimeType date = factory.createDateTimeType();
            String string = ch.getLastBuildOrUpdatedDate();
            if (!CommonUtils.isDateFormatValid(string, FeedFormat.ATOM10)) {
                String newDateString = CommonUtils.formatDate(CommonUtils.tryParseDate(string), FeedFormat.ATOM10);
                if (newDateString != null) {
                    String string2 = newDateString;
                } else {
                    LOG.warn((Object)("The dateString " + string + " is in valid according to ATOM 1.0 specs, unabel to convert it to a valid format, writing it as is"));
                }
            }
            date.setValue((String)var6_17);
            elementList.add(factory.createFeedTypeUpdated(date));
        }
        if (ch.getPubDate() != null) {
            LOG.info((Object)"PubDate under <feed> level is not supported, it will be ignored");
        }
        if (ch.getItems() != null) {
            for (ItemEntry itemEntry : ch.getItems()) {
                elementList.add(factory.createFeedTypeEntry(Atom10MappingUtils.toEntry(itemEntry)));
            }
        }
        ret.setBase(ch.getBase());
        ret.setLang(ch.getLang());
        if (ch.getOtherElements() != null) {
            elementList.addAll(ch.getOtherElements());
        }
        if (ch.getOtherAttributes() != null) {
            ret.getOtherAttributes().putAll(ch.getOtherAttributes());
        }
        return factory.createFeed(ret);
    }
}

