/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.tag.handler;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.international.LocaleSelector;
import org.jboss.seam.international.TimeZoneSelector;
import org.nuxeo.ecm.platform.ui.web.tag.handler.GenericHtmlComponentHandler;
import org.richfaces.component.UICalendar;

public class InputDateTimeTagHandler
extends GenericHtmlComponentHandler {
    private static final Log log = LogFactory.getLog(InputDateTimeTagHandler.class);
    protected final String defaultTime;
    protected TagAttributes attributes;

    public InputDateTimeTagHandler(ComponentConfig config) {
        super(config);
        this.attributes = config.getTag().getAttributes();
        this.defaultTime = this.getValue(this.attributes, "defaultTime", "12:00");
    }

    protected String getValue(TagAttributes attrs, String name, String defaultValue) {
        TagAttribute attr = attrs.get(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getValue();
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset m = super.createMetaRuleset(type);
        m.alias("format", "datePattern");
        m.ignore("showsTime");
        m.alias("triggerLabel", "buttonLabel");
        m.alias("triggerImg", "buttonIcon");
        m.alias("triggerStyleClass", "buttonClass");
        m.alias("onclick", "oninputclick");
        m.add((Metadata)new TagMetaData());
        return m;
    }

    public void setAttributes(FaceletContext ctx, Object instance) {
        super.setAttributes(ctx, instance);
        UICalendar c = (UICalendar)instance;
        c.setPopup(Boolean.parseBoolean(this.getValue(this.attributes, "popup", "true")));
        c.setEnableManualInput(Boolean.parseBoolean(this.getValue(this.attributes, "enableManualInput", "true")));
        c.setShowApplyButton(Boolean.parseBoolean(this.getValue(this.attributes, "showApplyButton", "false")));
        c.setZindex(Integer.parseInt(this.getValue(this.attributes, "zindex", "1500")));
        this.setDefaultTime(c);
    }

    protected void setDefaultTime(UICalendar instance) {
        Date date;
        UICalendar c = instance;
        SimpleDateFormat format = new SimpleDateFormat("HH:mm");
        format.setTimeZone(instance.getTimeZone());
        try {
            date = format.parse(this.defaultTime);
        }
        catch (ParseException e) {
            return;
        }
        c.setDefaultTime((Object)date);
    }

    class TagMetaData
    extends Metadata {
        public void applyMetadata(FaceletContext ctx, Object instance) {
            if (!(instance instanceof UICalendar)) {
                log.error((Object)("Cannot apply date time component metadata, not a HtmlCalendar instance: " + instance));
                return;
            }
            UICalendar c = (UICalendar)instance;
            c.setTimeZone(TimeZoneSelector.instance().getTimeZone());
            c.setLocale((Object)LocaleSelector.instance().getLocale());
        }
    }
}

