/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import com.noelios.restlet.ext.servlet.ServletCall;
import com.noelios.restlet.http.HttpCall;
import com.noelios.restlet.http.HttpRequest;
import java.util.Map;
import javax.faces.event.PhaseId;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Manager;
import org.jboss.seam.servlet.ServletRequestSessionMap;
import org.jboss.seam.web.ServletContexts;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.restlet.Filter;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class SeamRestletFilter
extends Filter {
    private static final Log log = LogFactory.getLog(SeamRestletFilter.class);
    private boolean useConversation = false;

    public SeamRestletFilter() {
        this(false);
    }

    public SeamRestletFilter(boolean needConversation) {
        this.useConversation = needConversation;
    }

    protected void beforeHandle(Request request, Response response) {
        HttpCall httpCall;
        FacesLifecycle.setPhaseId((PhaseId)PhaseId.INVOKE_APPLICATION);
        if (this.useConversation && request instanceof HttpRequest && (httpCall = ((HttpRequest)request).getHttpCall()) instanceof ServletCall) {
            HttpServletRequest httpServletRequest = ((ServletCall)httpCall).getRequest();
            ServletLifecycle.beginRequest((HttpServletRequest)httpServletRequest);
            ServletContexts.instance().setRequest(httpServletRequest);
            ConversationPropagation.instance().restoreConversationId(httpServletRequest.getParameterMap());
            Manager.instance().restoreConversation();
            ServletLifecycle.resumeConversation((HttpServletRequest)httpServletRequest);
            Manager.instance().handleConversationPropagation(httpServletRequest.getParameterMap());
            return;
        }
        Lifecycle.beginCall();
    }

    protected void afterHandle(Request request, Response response) {
        HttpCall httpCall;
        FacesLifecycle.setPhaseId(null);
        if (this.useConversation && request instanceof HttpRequest && (httpCall = ((HttpRequest)request).getHttpCall()) instanceof ServletCall) {
            if (TransactionHelper.isTransactionActive()) {
                TransactionHelper.commitOrRollbackTransaction();
            }
            HttpServletRequest httpServletRequest = ((ServletCall)httpCall).getRequest();
            Manager.instance().endRequest((Map)new ServletRequestSessionMap(httpServletRequest));
            ServletLifecycle.endRequest((HttpServletRequest)httpServletRequest);
            return;
        }
        Lifecycle.endCall();
    }

    protected void doHandle(Request request, Response response) {
        if (this.getNext() != null) {
            Restlet next = this.getNext();
            Restlet seamRestlet = (Restlet)SeamComponentCallHelper.getSeamComponentByRef(next);
            if (seamRestlet == null) {
                String errMsg = "Cannot get Seam component for restlet ";
                log.error((Object)("Cannot get Seam component for restlet " + next));
                response.setEntity("Cannot get Seam component for restlet ", MediaType.TEXT_PLAIN);
            } else {
                try {
                    seamRestlet.handle(request, response);
                }
                catch (RuntimeException e) {
                    log.error((Object)"Restlet handling error", (Throwable)e);
                    response.setEntity("Error while calling Seam aware Restlet: " + e.getMessage(), MediaType.TEXT_PLAIN);
                }
            }
        } else {
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
    }
}

