/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.validator.BeanValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class MethodExpressionValidator
implements Validator,
StateHolder {
    private static final String BEANS_VALIDATION_AVAILABLE = "javax.faces.private.BEANS_VALIDATION_AVAILABLE";
    private static final String VALIDATE_EMPTY_FIELDS_PARAM_NAME = "javax.faces.VALIDATE_EMPTY_FIELDS";
    private MethodExpression methodExpression = null;
    private Boolean validateEmptyFields;
    private boolean transientValue = false;

    public MethodExpressionValidator() {
    }

    public MethodExpressionValidator(MethodExpression methodExpression) {
        this.methodExpression = methodExpression;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (this.validateEmptyFields(context) || value != null) {
            try {
                ELContext elContext = context.getELContext();
                this.methodExpression.invoke(elContext, new Object[]{context, component, value});
            }
            catch (ELException ee) {
                Throwable e = ee.getCause();
                if (e instanceof ValidatorException) {
                    throw (ValidatorException)e;
                }
                throw ee;
            }
        }
    }

    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object[] values = new Object[]{this.methodExpression};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        this.methodExpression = (MethodExpression)values[0];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    private boolean validateEmptyFields(FacesContext ctx) {
        if (this.validateEmptyFields == null) {
            ExternalContext extCtx = ctx.getExternalContext();
            String val = extCtx.getInitParameter(VALIDATE_EMPTY_FIELDS_PARAM_NAME);
            if (null == val) {
                val = (String)extCtx.getApplicationMap().get(VALIDATE_EMPTY_FIELDS_PARAM_NAME);
            }
            this.validateEmptyFields = val == null || "auto".equals(val) ? Boolean.valueOf(this.isBeansValidationAvailable(ctx)) : Boolean.valueOf(val);
        }
        return this.validateEmptyFields;
    }

    private boolean isBeansValidationAvailable(FacesContext context) {
        boolean result = false;
        Map<String, Object> appMap = context.getExternalContext().getApplicationMap();
        if (appMap.containsKey(BEANS_VALIDATION_AVAILABLE)) {
            result = (Boolean)appMap.get(BEANS_VALIDATION_AVAILABLE);
        } else {
            try {
                new BeanValidator();
                appMap.put(BEANS_VALIDATION_AVAILABLE, Boolean.TRUE);
                result = true;
            }
            catch (Throwable t) {
                appMap.put(BEANS_VALIDATION_AVAILABLE, Boolean.FALSE);
            }
        }
        return result;
    }
}

