/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application.configuration;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.richfaces.application.configuration.ConfigurationItem;
import org.richfaces.application.configuration.ConfigurationItemSource;
import org.richfaces.application.configuration.ConfigurationItemsBundle;
import org.richfaces.application.configuration.ConfigurationService;
import org.richfaces.application.configuration.ValueExpressionHolder;
import org.richfaces.el.util.ELUtils;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;

public class ConfigurationServiceImpl
implements ConfigurationService {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    private static final String JNDI_COMP_PREFIX = "java:comp/env/";
    private Map<Enum<?>, ValueExpressionHolder> itemsMap = new ConcurrentHashMap();
    private AtomicBoolean webEnvironmentUnavailableLogged = new AtomicBoolean();

    private ConfigurationItem getConfigurationItem(Enum<?> enumKey) {
        try {
            ConfigurationItem item = enumKey.getClass().getField(enumKey.name()).getAnnotation(ConfigurationItem.class);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(MessageFormat.format("Cannot read @ConfigurationItem annotation from {0}.{1} because of {2}", enumKey.getClass().getName(), enumKey.name(), e.getMessage()));
        }
        throw new IllegalStateException(MessageFormat.format("Annotation @ConfigurationItem is not set at {0}.{1}", enumKey.getClass().getName(), enumKey.name()));
    }

    protected ValueExpressionHolder createValueExpressionHolder(FacesContext context, ValueExpression expression, String defaultValueString, Class<?> returnType) {
        Object defaultValue = null;
        if (!(expression != null && expression.isLiteralText() || Strings.isNullOrEmpty((String)defaultValueString))) {
            defaultValue = ELUtils.coerce(defaultValueString, returnType);
        }
        return new ValueExpressionHolder(expression, defaultValue);
    }

    private String getInitParameterValue(FacesContext context, ConfigurationItem configurationItem) {
        for (String name : configurationItem.names()) {
            String value = context.getExternalContext().getInitParameter(name);
            if (Strings.isNullOrEmpty((String)value)) continue;
            return value;
        }
        return null;
    }

    private String getWebEnvironmentEntryValue(ConfigurationItem configurationItem) {
        InitialContext context;
        block6: {
            context = null;
            try {
                context = new InitialContext();
            }
            catch (Throwable e) {
                if (this.webEnvironmentUnavailableLogged.getAndSet(true)) break block6;
                LOGGER.error(e.getMessage(), e);
            }
        }
        if (context != null) {
            for (String envName : configurationItem.names()) {
                String value;
                block7: {
                    String qualifiedName = !envName.startsWith(JNDI_COMP_PREFIX) ? JNDI_COMP_PREFIX + envName : envName;
                    value = null;
                    try {
                        value = (String)context.lookup(qualifiedName);
                    }
                    catch (NamingException e) {
                        if (!LOGGER.isDebugEnabled()) break block7;
                        LOGGER.debug(e.getMessage(), e);
                    }
                }
                if (Strings.isNullOrEmpty((String)value)) continue;
                return value;
            }
        }
        return null;
    }

    private ValueExpression createContextValueExpression(FacesContext context, ConfigurationItem annotation, Class<?> targetType) {
        ConfigurationItemSource source = annotation.source();
        if (source == ConfigurationItemSource.defaultSource) {
            source = ConfigurationItemSource.contextInitParameter;
        }
        String parameterValue = null;
        if (source == ConfigurationItemSource.contextInitParameter) {
            parameterValue = this.getInitParameterValue(context, annotation);
        } else if (source == ConfigurationItemSource.webEnvironmentEntry) {
            parameterValue = this.getWebEnvironmentEntryValue(annotation);
        } else {
            throw new IllegalArgumentException(source.toString());
        }
        if (!Strings.isNullOrEmpty((String)parameterValue)) {
            return ELUtils.createValueExpression(context, parameterValue, annotation.literal(), targetType);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T getValue(FacesContext facesContext, Enum<?> key, Class<T> returnType) {
        ValueExpressionHolder holder = this.itemsMap.get(key);
        if (holder == null) {
            ConfigurationItemsBundle configurationItemsBundle = this.getConfigurationItemsBundle(key);
            if (configurationItemsBundle == null) {
                ConfigurationItem item = this.getConfigurationItem(key);
                ValueExpression expression = this.createContextValueExpression(facesContext, item, returnType);
                holder = this.createValueExpressionHolder(facesContext, expression, item.defaultValue(), returnType);
                this.itemsMap.put(key, holder);
            } else {
                Class<?> clazz = key.getClass();
                synchronized (clazz) {
                    Properties properties = this.loadProperties(configurationItemsBundle.propertiesFile());
                    for (Enum nextBundleKey : EnumSet.allOf(key.getClass())) {
                        String propertyName;
                        ConfigurationItem item = this.getConfigurationItem(nextBundleKey);
                        if (item.source() != ConfigurationItemSource.defaultSource) {
                            throw new IllegalArgumentException(item.toString());
                        }
                        String parameterValue = null;
                        String[] stringArray = item.names();
                        int n = stringArray.length;
                        for (int i = 0; i < n && (parameterValue = properties.getProperty(propertyName = stringArray[i])) == null; ++i) {
                        }
                        ValueExpression expression = null;
                        if (parameterValue != null) {
                            expression = ELUtils.createValueExpression(facesContext, parameterValue, item.literal(), returnType);
                        }
                        ValueExpressionHolder siblingHolder = this.createValueExpressionHolder(facesContext, expression, item.defaultValue(), returnType);
                        this.itemsMap.put(nextBundleKey, siblingHolder);
                        if (key != nextBundleKey) continue;
                        holder = siblingHolder;
                    }
                }
            }
        }
        return returnType.cast(holder.getValue(facesContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String resourceName) {
        URL url;
        Properties properties = new Properties();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null && (url = classLoader.getResource(resourceName)) != null) {
            InputStream is = null;
            try {
                is = URLToStreamHelper.urlToStream(url);
                properties.load(is);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    private ConfigurationItemsBundle getConfigurationItemsBundle(Enum<?> key) {
        ConfigurationItem item = this.getConfigurationItem(key);
        ConfigurationItemSource source = item.source();
        if (source == ConfigurationItemSource.defaultSource) {
            Class<?> enclosingClass = key.getClass();
            return enclosingClass.getAnnotation(ConfigurationItemsBundle.class);
        }
        return null;
    }

    @Override
    public Boolean getBooleanValue(FacesContext facesContext, Enum<?> key) {
        return this.getValue(facesContext, key, Boolean.class);
    }

    @Override
    public Integer getIntValue(FacesContext facesContext, Enum<?> key) {
        return this.getValue(facesContext, key, Integer.class);
    }

    @Override
    public Long getLongValue(FacesContext facesContext, Enum<?> key) {
        return this.getValue(facesContext, key, Long.class);
    }

    @Override
    public String getStringValue(FacesContext facesContext, Enum<?> key) {
        return this.getValue(facesContext, key, String.class);
    }

    @Override
    public <T extends Enum<T>> T getEnumValue(FacesContext facesContext, Enum<?> key, Class<T> enumClass) {
        return (T)((Enum)this.getValue(facesContext, key, enumClass));
    }

    @Override
    public Object getValue(FacesContext facesContext, Enum<?> key) {
        return this.getValue(facesContext, key, Object.class);
    }
}

