/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.component.file;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputFile;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.validator.Validator;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileInfo;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileMimetypeValidator;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileSizeValidator;
import org.nuxeo.ecm.platform.ui.web.component.file.JSFBlobUploader;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

public class HTMLBlobUploader
implements JSFBlobUploader {
    protected static final String UPLOAD_FACET_NAME = "upload";

    public HTMLBlobUploader(String id) {
    }

    @Override
    public String getChoice() {
        return UPLOAD_FACET_NAME;
    }

    @Override
    public void hookSubComponent(UIInput parent) {
        FacesContext faces = FacesContext.getCurrentInstance();
        Application app = faces.getApplication();
        ComponentUtils.initiateSubComponent((UIComponent)parent, UPLOAD_FACET_NAME, app.createComponent(faces, "javax.faces.HtmlInputFile", "javax.faces.NXFile"));
    }

    @Override
    public void encodeBeginUpload(UIInput parent, FacesContext context, String onClick) throws IOException {
        UIComponent facet = parent.getFacet(UPLOAD_FACET_NAME);
        if (!(facet instanceof HtmlInputFile)) {
            return;
        }
        HtmlInputFile inputFile = (HtmlInputFile)facet;
        ResponseWriter writer = context.getResponseWriter();
        long sizeMax = 0L;
        String sizeConstraint = null;
        ArrayList<String> authorizedExtensions = new ArrayList<String>();
        ArrayList<String> unauthorizedExtensions = new ArrayList<String>();
        boolean hidden = false;
        for (Validator val : parent.getValidators()) {
            if (val instanceof InputFileSizeValidator) {
                InputFileSizeValidator sizeVal = (InputFileSizeValidator)val;
                long currentSizeMax = sizeVal.getMaxSizeBytes();
                if (currentSizeMax <= sizeMax) continue;
                sizeMax = currentSizeMax;
                sizeConstraint = sizeVal.getMaxSize();
                continue;
            }
            if (!(val instanceof InputFileMimetypeValidator)) continue;
            InputFileMimetypeValidator extVal = (InputFileMimetypeValidator)val;
            hidden = extVal.isHidden();
            if (extVal.isAuthorized()) {
                authorizedExtensions.addAll(Arrays.asList(extVal.getExtensions()));
                continue;
            }
            unauthorizedExtensions.addAll(Arrays.asList(extVal.getExtensions()));
        }
        ArrayList<String> constraints = new ArrayList<String>();
        if (sizeConstraint != null) {
            constraints.add(ComponentUtils.translate(context, "label.inputFile.maxSize", sizeConstraint));
        }
        if (!(hidden || authorizedExtensions.isEmpty() && unauthorizedExtensions.isEmpty())) {
            if (!authorizedExtensions.isEmpty()) {
                constraints.add(ComponentUtils.translate(context, "label.inputFile.authorizedExtensions", StringUtils.join((Object[])authorizedExtensions.toArray(), (String)", ")));
            }
            if (!unauthorizedExtensions.isEmpty()) {
                constraints.add(ComponentUtils.translate(context, "label.inputFile.unauthorizedExtensions", StringUtils.join((Object[])unauthorizedExtensions.toArray(), (String)", ")));
            }
        }
        if (constraints.size() > 0) {
            writer.write("(");
            writer.write(StringUtils.join((Object[])constraints.toArray(), (String)", "));
            writer.write(")");
            writer.write("&#x0020;");
        }
        inputFile.setOnclick(onClick);
        ComponentUtils.encodeComponent(context, (UIComponent)inputFile);
    }

    @Override
    public void validateUpload(UIInput parent, FacesContext context, InputFileInfo submitted) {
        UIComponent facet = parent.getFacet(UPLOAD_FACET_NAME);
        if (!(facet instanceof HtmlInputFile)) {
            return;
        }
        HtmlInputFile inputFile = (HtmlInputFile)facet;
        Object submittedFile = inputFile.getSubmittedValue();
        if (!(submittedFile instanceof Blob)) {
            return;
        }
        Blob sblob = (Blob)submittedFile;
        if (sblob.getLength() == 0L) {
            String message = context.getPartialViewContext().isAjaxRequest() ? "error.inputFile.ajax" : "error.inputFile.invalidFile";
            ComponentUtils.addErrorMessage(context, (UIComponent)parent, message);
            parent.setValid(false);
            return;
        }
        submitted.setBlob(sblob);
        submitted.setFilename(sblob.getFilename());
        submitted.setMimeType(sblob.getMimeType());
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

