/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.Resource;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.context.FacesContext;
import org.richfaces.renderkit.InputRendererBase;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(library="org.richfaces", name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="richfaces-utils.js"), @ResourceDependency(library="org.richfaces.ckeditor", name="ckeditor.js"), @ResourceDependency(library="org.richfaces.ckeditor", name="config.js"), @ResourceDependency(library="org.richfaces", name="editor.js")})
public class EditorRendererBase
extends InputRendererBase {
    public static final String DEFAULT_WIDTH = "100%";
    public static final String DEFAULT_HEIGHT = "200px";
    private Pattern DB_PATTERN = Pattern.compile("(^|.*[&|?])(db=[^&]*).*");

    public String resolveUnits(Object dimension) {
        String dim = (String)dimension;
        if (dim.matches("^[0-9]+$")) {
            return dim + "px";
        }
        return dim;
    }

    public String getCKEditorRequestPath(FacesContext facesContext) {
        Resource resource = facesContext.getApplication().getResourceHandler().createResource("ckeditor.js", "org.richfaces.ckeditor");
        return resource.getRequestPath();
    }

    public String getECSSQueryString(FacesContext facesContext, String resourceName) {
        Resource resource = facesContext.getApplication().getResourceHandler().createResource(resourceName, "org.richfaces.ckeditor");
        String requestPath = resource.getRequestPath();
        Matcher matcher = this.DB_PATTERN.matcher(requestPath);
        if (matcher.matches()) {
            return "?" + matcher.group(2);
        }
        return "";
    }
}

