/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Property;
import org.hibernate.validator.Max;
import org.hibernate.validator.PropertyConstraint;
import org.hibernate.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxValidator
implements Validator<Max>,
PropertyConstraint,
Serializable {
    private long max;

    @Override
    public void initialize(Max parameters) {
        this.max = parameters.value();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            try {
                return new BigDecimal((String)value).compareTo(BigDecimal.valueOf(this.max)) <= 0;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if (value instanceof Double || value instanceof Float) {
            double dv = ((Number)value).doubleValue();
            return dv <= (double)this.max;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).compareTo(BigInteger.valueOf(this.max)) <= 0;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).compareTo(BigDecimal.valueOf(this.max)) <= 0;
        }
        if (value instanceof Number) {
            long lv = ((Number)value).longValue();
            return lv <= this.max;
        }
        return false;
    }

    @Override
    public void apply(Property property) {
        Column col = (Column)property.getColumnIterator().next();
        col.setCheckConstraint(col.getName() + "<=" + this.max);
    }
}

