/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.tag.fn.LiveEditConstants;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.runtime.api.Framework;
import org.restlet.data.Request;
import org.restlet.data.Response;

@Name(value="downloadFileRestlet")
@Scope(value=ScopeType.EVENT)
public class DownloadFileRestlet
extends BaseNuxeoRestlet
implements LiveEditConstants,
Serializable {
    private static final long serialVersionUID = -2163290273836947871L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected CoreSession documentManager;

    public void handle(Request req, Response res) {
        DocumentModel dm;
        HttpServletRequest request = DownloadFileRestlet.getHttpRequest(req);
        HttpServletResponse response = DownloadFileRestlet.getHttpResponse(res);
        String repo = (String)req.getAttributes().get("repo");
        if (repo == null || repo.equals("*")) {
            DownloadFileRestlet.handleError(res, "you must specify a repository");
            return;
        }
        try {
            this.navigationContext.setCurrentServerLocation(new RepositoryLocation(repo));
            this.documentManager = this.navigationContext.getOrCreateDocumentManager();
            String docid = (String)req.getAttributes().get("docid");
            if (docid == null) {
                DownloadFileRestlet.handleError(res, "you must specify a valid document IdRef");
                return;
            }
            dm = this.documentManager.getDocument((DocumentRef)new IdRef(docid));
        }
        catch (NuxeoException e) {
            DownloadFileRestlet.handleError(res, (Exception)((Object)e));
            return;
        }
        try {
            String xpath;
            Blob blob;
            String filename;
            String blobPropertyName = DownloadFileRestlet.getQueryParamValue(req, "blobPropertyName", null);
            String filenamePropertyName = DownloadFileRestlet.getQueryParamValue(req, "filenamePropertyName", null);
            if (blobPropertyName != null && filenamePropertyName != null) {
                filename = (String)((Object)dm.getPropertyValue(filenamePropertyName));
                blob = (Blob)dm.getPropertyValue(blobPropertyName);
                xpath = blobPropertyName;
            } else {
                String schemaName = DownloadFileRestlet.getQueryParamValue(req, "schema", "file");
                String blobFieldName = DownloadFileRestlet.getQueryParamValue(req, "blobField", "content");
                String filenameFieldName = DownloadFileRestlet.getQueryParamValue(req, "filenameField", "filename");
                filename = (String)dm.getProperty(schemaName, filenameFieldName);
                blob = (Blob)dm.getProperty(schemaName, blobFieldName);
                xpath = schemaName + ':' + blobFieldName;
            }
            if (StringUtils.isBlank((String)filename)) {
                filename = StringUtils.defaultIfBlank((String)blob.getFilename(), (String)"file");
            }
            String reason = "download";
            Map extendedInfos = null;
            DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
            downloadService.downloadBlob(request, response, dm, xpath, blob, filename, reason, extendedInfos, null, byteRange -> this.setEntityToBlobOutput(blob, (DownloadService.ByteRange)byteRange, res));
        }
        catch (IOException | NuxeoException e) {
            DownloadFileRestlet.handleError(res, (Exception)e);
        }
    }
}

