/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.model.impl;

import org.nuxeo.ecm.diff.model.DifferenceType;
import org.nuxeo.ecm.diff.model.PropertyDiff;
import org.nuxeo.ecm.diff.model.impl.ContentProperty;

public class ContentPropertyDiff
extends PropertyDiff {
    private static final long serialVersionUID = -1030336913574192065L;
    protected ContentProperty leftContent;
    protected ContentProperty rightContent;

    public ContentPropertyDiff() {
        this.propertyType = "content";
    }

    public ContentPropertyDiff(DifferenceType differenceType) {
        this();
        this.differenceType = differenceType;
    }

    public ContentPropertyDiff(ContentProperty leftContent, ContentProperty rightContent) {
        this(DifferenceType.different, leftContent, rightContent);
    }

    public ContentPropertyDiff(DifferenceType differenceType, ContentProperty leftContent, ContentProperty rightContent) {
        this("content", differenceType, leftContent, rightContent);
    }

    public ContentPropertyDiff(String propertyType, DifferenceType differenceType, ContentProperty leftContent, ContentProperty rightContent) {
        this.propertyType = propertyType;
        this.differenceType = differenceType;
        this.leftContent = leftContent;
        this.rightContent = rightContent;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContentPropertyDiff)) {
            return false;
        }
        ContentProperty otherLeftContent = ((ContentPropertyDiff)other).getLeftContent();
        ContentProperty otherRightContent = ((ContentPropertyDiff)other).getRightContent();
        return this.leftContent == null && otherLeftContent == null && this.rightContent == null && otherRightContent == null || this.leftContent == null && otherLeftContent == null && this.rightContent != null && this.rightContent.equals(otherRightContent) || this.rightContent == null && otherRightContent == null && this.leftContent != null && this.leftContent.equals(otherLeftContent) || this.leftContent != null && this.rightContent != null && this.leftContent.equals(otherLeftContent) && this.rightContent.equals(otherRightContent);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.leftContent);
        sb.append(" --> ");
        sb.append(this.rightContent);
        sb.append(super.toString());
        return sb.toString();
    }

    public ContentProperty getLeftContent() {
        return this.leftContent;
    }

    public void setLeftContent(ContentProperty leftContent) {
        this.leftContent = leftContent;
    }

    public ContentProperty getRightContent() {
        return this.rightContent;
    }

    public void setRightContent(ContentProperty rightContent) {
        this.rightContent = rightContent;
    }
}

