/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.regex.Pattern;

public final class MorePredicates {
    private MorePredicates() {
    }

    public static <S, D> Predicate<D> any(Iterable<S> options, Function<S, Predicate<D>> function) {
        if (options == null || Iterables.isEmpty(options)) {
            return Predicates.alwaysTrue();
        }
        return Predicates.or((Iterable)Iterables.transform(options, function));
    }

    public static <S, D> Predicate<D> none(Iterable<S> options, Function<S, Predicate<D>> function) {
        if (options == null || Iterables.isEmpty(options)) {
            return Predicates.alwaysTrue();
        }
        Predicate compositePredicate = Predicates.or((Iterable)Iterables.transform(options, function));
        return Predicates.not((Predicate)compositePredicate);
    }

    public static <S, D> Predicate<D> compose(Iterable<S> includes, Iterable<S> excludes, Function<S, Predicate<D>> function) {
        final Predicate<D> includesPredicate = MorePredicates.any(includes, function);
        final Predicate<D> excludesPredicate = MorePredicates.none(excludes, function);
        return new Predicate<D>(){

            public boolean apply(D input) {
                return includesPredicate.apply(input) && excludesPredicate.apply(input);
            }
        };
    }

    public static Predicate<String> startsWith(final String prefix) {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return input.startsWith(prefix);
            }
        };
    }

    public static Predicate<CharSequence> matches(final Pattern pattern) {
        return new Predicate<CharSequence>(){

            public boolean apply(CharSequence input) {
                return pattern.matcher(input).matches();
            }
        };
    }
}

