/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.service;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.runtime.api.Framework;

public final class ComplexPropertyHelper {
    public static Field getField(String schemaName, String fieldName) throws ClientException {
        Schema schema = ComplexPropertyHelper.getSchemaManager().getSchema(schemaName);
        if (schema == null) {
            throw new ClientException(String.format("Schema [%s] does not exist.", schemaName));
        }
        Field field = schema.getField(fieldName);
        if (field == null) {
            throw new ClientException(String.format("Field [%s] does not exist in schema [%s].", fieldName, schemaName));
        }
        return field;
    }

    public static Field getComplexFieldItem(Field field, String complexItemName) throws ClientException {
        Type fieldType = field.getType();
        if (!fieldType.isComplexType()) {
            throw new ClientException(String.format("Field '%s' is not a complex type.", field));
        }
        return ((ComplexType)fieldType).getField(complexItemName);
    }

    public static List<Field> getComplexFieldItems(Field field) throws ClientException {
        Type fieldType = field.getType();
        if (!fieldType.isComplexType()) {
            throw new ClientException(String.format("Field [%s] is not a complex type.", field.getName().getLocalName()));
        }
        return new ArrayList<Field>(((ComplexType)fieldType).getFields());
    }

    public static Field getListFieldItem(Field field) throws ClientException {
        Type fieldType = field.getType();
        if (!fieldType.isListType()) {
            throw new ClientException(String.format("Field [%s] is not a list type.", field.getName().getLocalName()));
        }
        Field listFieldItem = ((ListType)fieldType).getField();
        if (listFieldItem == null) {
            throw new ClientException(String.format("Field [%s] is a list type but has no field defining the elements stored by this list.", field.getName().getLocalName()));
        }
        return listFieldItem;
    }

    public static String getFieldType(Field field) throws ClientException {
        Field listField;
        Type fieldType = field.getType();
        String fieldTypeName = fieldType.isComplexType() ? (TypeConstants.isContentType((Type)fieldType) ? "content" : "complex") : (fieldType.isListType() ? ((listField = ((ListType)fieldType).getField()).getType().isComplexType() ? "complexList" : "scalarList") : fieldType.getName());
        return fieldTypeName;
    }

    private static final SchemaManager getSchemaManager() throws ClientException {
        SchemaManager schemaManager;
        try {
            schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        }
        catch (Exception e) {
            throw ClientException.wrap((Throwable)e);
        }
        if (schemaManager == null) {
            throw new ClientException("SchemaManager service is null.");
        }
        return schemaManager;
    }
}

