/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.wss.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.wss.WSSConfig;

public class WSSStaticResponse {
    protected HttpServletResponse httpResponse;
    protected boolean processed = false;
    protected String contentType = null;
    protected InputStream additionnalStream;

    public WSSStaticResponse(HttpServletResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public void processIfNeeded() throws ServletException, IOException {
        if (!this.processed) {
            this.process();
        }
    }

    public void process() throws ServletException, IOException {
        if (this.processed) {
            throw new ServletException("process called twice on WSSResponse");
        }
        this.processHeaders();
        this.processRender();
        this.processed = true;
    }

    public void addBinaryStream(InputStream stream) {
        this.additionnalStream = stream;
    }

    protected void processHeaders() {
        this.getHttpResponse().setHeader("MicrosoftSharePointTeamServices", WSSConfig.instance().getTSServerVersion());
        this.getHttpResponse().setHeader("Set-Cookie", "WSS_KeepSessionAuthenticated=80; path=/");
        this.getHttpResponse().setHeader("X-Powered-By", "ASP.NET");
        if (this.contentType == null) {
            this.getHttpResponse().setHeader("Content-type", this.getDefaultContentType());
        } else {
            this.getHttpResponse().setHeader("Content-type", this.contentType);
        }
    }

    protected String getDefaultContentType() {
        return "text/plain";
    }

    protected void processRender() throws IOException {
    }

    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public void setContentType(String ct) {
        this.contentType = ct;
    }
}

