/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.http.proxy;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ProxyPacResolver {
    public static final String NO_PROXY = "DIRECT";

    public abstract String[] findPacProxies(String var1);

    public String[] findProxy(String url) {
        String[] proxy;
        String[] proxies = this.findPacProxies(url);
        if (proxies != null && proxies.length > 0 && !NO_PROXY.equals(proxies[0].trim().toUpperCase()) && (proxy = ProxyPacResolver.parseProxyInfos(proxies[0]))[0] != null) {
            return proxy;
        }
        return null;
    }

    protected static String getHost(String url) {
        try {
            return new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    protected static String[] parseProxyInfos(String proxy) {
        String[] split = new String[2];
        Pattern p = Pattern.compile("PROXY ([0-9a-zA-Z.]+)(:([0-9]{1,5}))*");
        Matcher matcher = p.matcher(proxy.trim());
        if (matcher.matches()) {
            split[0] = matcher.group(1);
            split[1] = matcher.group(3) != null ? matcher.group(3) : "-1";
        }
        return split;
    }
}

