/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.model.impl;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.ClientException;

public class ContentProperty
implements Serializable {
    private static final long serialVersionUID = 4258464052505119020L;
    protected String encoding;
    protected String mimeType;
    protected String filename;
    protected String digest;

    public ContentProperty() {
    }

    public ContentProperty(String encoding, String mimeType, String filename, String digest) {
        this.encoding = encoding;
        this.mimeType = mimeType;
        this.filename = filename;
        this.digest = digest;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public void setSubProperty(String subPropertyName, String subPropertyValue) throws ClientException {
        if ("encoding".equals(subPropertyName)) {
            this.setEncoding(subPropertyValue);
        } else if ("mime-type".equals(subPropertyName)) {
            this.setMimeType(subPropertyValue);
        } else if ("filename".equals(subPropertyName)) {
            this.setFilename(subPropertyValue);
        } else if ("digest".equals(subPropertyName)) {
            this.setDigest(subPropertyValue);
        } else if (!"data".equals(subPropertyName)) {
            throw new ClientException(String.format("Error while trying to set sub property '%s' on an object of type ContentProperty: no such sub property.", subPropertyName));
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContentProperty)) {
            return false;
        }
        String otherEncoding = ((ContentProperty)other).getEncoding();
        String otherMimeType = ((ContentProperty)other).getMimeType();
        String otherFilename = ((ContentProperty)other).getFilename();
        String otherDigest = ((ContentProperty)other).getDigest();
        if (this.encoding == null && otherEncoding == null && this.mimeType == null && otherMimeType == null && this.filename == null && otherFilename == null && this.digest == null && otherDigest == null) {
            return true;
        }
        return !this.notEquals(this.encoding, otherEncoding) && !this.notEquals(this.mimeType, otherMimeType) && !this.notEquals(this.filename, otherFilename) && !this.notEquals(this.digest, otherDigest);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("filename=");
        sb.append(this.filename);
        sb.append("; encoding=");
        sb.append(this.encoding);
        sb.append("; mimeType=");
        sb.append(this.mimeType);
        sb.append("; digest=");
        sb.append(this.digest);
        return sb.toString();
    }

    protected boolean notEquals(String s1, String s2) {
        return s1 == null && s2 != null || s1 != null && s2 == null || s1 != null && !s1.equals(s2);
    }
}

