/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.diff.model.DiffFieldDefinition;
import org.nuxeo.ecm.diff.model.DiffFieldItemDefinition;

public class DiffFieldDefinitionImpl
implements DiffFieldDefinition {
    private static final long serialVersionUID = 6192730067253949180L;
    protected String category;
    protected String schema;
    protected String name;
    protected boolean displayContentDiffLinks;
    protected List<DiffFieldItemDefinition> items;

    public DiffFieldDefinitionImpl(String category, String schema, String name) {
        this(category, schema, name, false);
    }

    public DiffFieldDefinitionImpl(String category, String schema, String name, boolean displayContentDiffLinks) {
        this(category, schema, name, displayContentDiffLinks, new ArrayList<DiffFieldItemDefinition>());
    }

    public DiffFieldDefinitionImpl(String category, String schema, String name, List<DiffFieldItemDefinition> items) {
        this(category, schema, name, false, items);
    }

    public DiffFieldDefinitionImpl(String category, String schema, String name, boolean displayContentDiffLinks, List<DiffFieldItemDefinition> items) {
        this.category = category;
        this.schema = schema;
        this.name = name;
        this.displayContentDiffLinks = displayContentDiffLinks;
        this.items = items;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDisplayContentDiffLinks() {
        return this.displayContentDiffLinks;
    }

    @Override
    public List<DiffFieldItemDefinition> getItems() {
        return this.items;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DiffFieldDefinition)) {
            return false;
        }
        String otherCategory = ((DiffFieldDefinition)other).getCategory();
        String otherSchema = ((DiffFieldDefinition)other).getSchema();
        String otherName = ((DiffFieldDefinition)other).getName();
        boolean otherDisplayContentDiffLinks = ((DiffFieldDefinition)other).isDisplayContentDiffLinks();
        if (this.category == null && otherCategory == null && this.schema == null && otherSchema == null && this.name == null && otherName == null) {
            return true;
        }
        if (this.schema == null || otherSchema == null || this.name == null || otherName == null || this.category == null && otherCategory != null || this.category != null && otherCategory == null || this.category != null && !this.category.equals(otherCategory) || this.schema != null && !this.schema.equals(otherSchema) || this.name != null && !this.name.equals(otherName) || this.displayContentDiffLinks != otherDisplayContentDiffLinks) {
            return false;
        }
        List<DiffFieldItemDefinition> otherItems = ((DiffFieldDefinition)other).getItems();
        if (CollectionUtils.isEmpty(this.items) && CollectionUtils.isEmpty(otherItems)) {
            return true;
        }
        return !(CollectionUtils.isEmpty(this.items) && !CollectionUtils.isEmpty(otherItems) || !CollectionUtils.isEmpty(this.items) && CollectionUtils.isEmpty(otherItems)) && ((Object)this.items).equals(otherItems);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("category=");
        sb.append(this.category);
        sb.append(" / ");
        sb.append(this.schema);
        sb.append(":");
        sb.append(this.name);
        sb.append(" / ");
        sb.append("displayContentDiffLinks=");
        sb.append(this.displayContentDiffLinks);
        sb.append(!CollectionUtils.isEmpty(this.items) ? " / " + this.items : "");
        return sb.toString();
    }
}

