/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.diff.pictures;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.diff.pictures.DiffPictures;
import org.nuxeo.diff.pictures.DiffPicturesUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;

@Operation(id="Pictures.DiffWithDocs", category="Conversion", label="Pictures: Diff with Docs", description="Compare the pictures of the two documents (referenced by their ID or their path), using the commandLine and its parameters (default values apply). Does nopt check the documents contain pictures. Return the result of the diff as a picture")
public class DiffPicturesWithDocsOp {
    public static final String ID = "Pictures.DiffWithDocs";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Param(name="leftDoc", required=true)
    protected DocumentModel leftDoc;
    @Param(name="rightDoc", required=true)
    protected DocumentModel rightDoc;
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath;
    @Param(name="commandLine", required=false, values={"diff-pictures-default"})
    protected String commandLine = "diff-pictures-default";
    @Param(name="parameters", required=false)
    protected Properties parameters;
    @Param(name="targetFileName", required=false)
    protected String targetFileName;
    @Param(name="targetFileNameSuffix", required=false)
    protected String targetFileNameSuffix = "";

    @OperationMethod
    public Blob run() throws OperationException, CommandNotAvailable, IOException {
        HashMap<String, Serializable> serializableParameters = new HashMap<String, Serializable>();
        if (this.parameters != null && this.parameters.size() > 0) {
            Set parameterNames = this.parameters.keySet();
            for (String parameterName : parameterNames) {
                serializableParameters.put(parameterName, (Serializable)this.parameters.get((Object)parameterName));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.targetFileName) || StringUtils.isNotBlank((CharSequence)this.targetFileNameSuffix)) {
            this.targetFileName = DiffPicturesUtils.addSuffixToFileName(this.targetFileName, this.targetFileNameSuffix);
            serializableParameters.put("targetFileName", (Serializable)((Object)this.targetFileName));
        }
        DiffPictures dp = new DiffPictures(this.leftDoc, this.rightDoc, this.xpath);
        return dp.compare(this.commandLine, serializableParameters);
    }
}

