/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.content.adapter.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.diff.content.ContentDiffException;
import org.nuxeo.ecm.diff.content.ContentDiffHelper;
import org.nuxeo.ecm.diff.content.adapter.HtmlContentDiffer;
import org.nuxeo.ecm.diff.content.adapter.MimeTypeContentDiffer;
import org.nuxeo.ecm.diff.content.adapter.base.AbstractContentDiffAdapter;
import org.nuxeo.ecm.diff.content.adapter.base.ContentDiffConversionType;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

public class ConverterBasedContentDiffAdapter
extends AbstractContentDiffAdapter {
    private static final Log log = LogFactory.getLog(ConverterBasedContentDiffAdapter.class);
    protected static final String DEFAULT_CONVERTER_NAME = "any2text";
    protected String defaultFieldXPath;
    protected MimetypeRegistry mimeTypeService;

    @Override
    public List<Blob> getContentDiffBlobs(DocumentModel otherDoc, ContentDiffConversionType conversionType, Locale locale) throws ContentDiffException, ConversionException {
        return this.getContentDiffBlobs(otherDoc, this.getDefaultContentDiffFieldXPath(), conversionType, locale);
    }

    @Override
    public List<Blob> getContentDiffBlobs(DocumentModel otherDoc, String xpath, ContentDiffConversionType conversionType, Locale locale) throws ContentDiffException, ConversionException {
        MimeTypeContentDiffer mtContentDiffer;
        Blob adaptedDocBlob = null;
        Blob otherDocBlob = null;
        BlobHolder adaptedDocBlobHolder = null;
        BlobHolder otherDocBlobHolder = null;
        if (xpath == null || "default".equals(xpath)) {
            adaptedDocBlobHolder = (BlobHolder)this.adaptedDoc.getAdapter(BlobHolder.class);
            otherDocBlobHolder = (BlobHolder)otherDoc.getAdapter(BlobHolder.class);
        } else {
            adaptedDocBlobHolder = ContentDiffHelper.getBlobHolder(this.adaptedDoc, xpath);
            otherDocBlobHolder = ContentDiffHelper.getBlobHolder(otherDoc, xpath);
        }
        if (adaptedDocBlobHolder == null || otherDocBlobHolder == null) {
            throw new ContentDiffException("Can not make a content diff of documents without a blob");
        }
        adaptedDocBlob = adaptedDocBlobHolder.getBlob();
        otherDocBlob = otherDocBlobHolder.getBlob();
        if (adaptedDocBlob == null || otherDocBlob == null) {
            throw new ContentDiffException("Can not make a content diff of documents without a blob");
        }
        ArrayList<Blob> blobResults = new ArrayList();
        String adaptedDocMimeType = this.getMimeType(adaptedDocBlob);
        String otherDocMimeType = this.getMimeType(otherDocBlob);
        log.debug((Object)("Mime type of adapted doc for HTML content diff = " + adaptedDocMimeType));
        log.debug((Object)("Mime type of other doc for HTML content diff = " + otherDocMimeType));
        if (adaptedDocMimeType != null && otherDocMimeType != null && adaptedDocMimeType.equals(otherDocMimeType) && (mtContentDiffer = this.getContentDiffAdapterManager().getContentDiffer(adaptedDocMimeType)) != null) {
            if (mtContentDiffer instanceof HtmlContentDiffer && !"text/html".equals(adaptedDocMimeType)) {
                adaptedDocBlob = this.getHtmlStringBlob(adaptedDocBlob);
                otherDocBlob = this.getHtmlStringBlob(otherDocBlob);
            }
            blobResults = mtContentDiffer.getContentDiff(adaptedDocBlob, otherDocBlob, locale);
            return blobResults;
        }
        if (conversionType == null) {
            conversionType = ContentDiffConversionType.html;
        }
        String converterName = conversionType.getValue();
        BlobHolder adaptedDocConvertedBlobHolder = this.getConvertedBlobHolder(adaptedDocBlobHolder, converterName);
        BlobHolder otherDocConvertedBlobHolder = this.getConvertedBlobHolder(otherDocBlobHolder, converterName);
        Blob adaptedDocConvertedBlob = adaptedDocConvertedBlobHolder.getBlob();
        Blob otherDocConvertedBlob = otherDocConvertedBlobHolder.getBlob();
        if (ContentDiffConversionType.text.equals((Object)conversionType)) {
            adaptedDocConvertedBlob = this.getHtmlStringBlob(adaptedDocConvertedBlob);
            otherDocConvertedBlob = this.getHtmlStringBlob(otherDocConvertedBlob);
        }
        HtmlContentDiffer contentDiffer = this.getContentDiffAdapterManager().getHtmlContentDiffer();
        blobResults.addAll(contentDiffer.getContentDiff(adaptedDocConvertedBlob, otherDocConvertedBlob, locale));
        this.addSecondaryBlobs(blobResults, adaptedDocConvertedBlobHolder, adaptedDocConvertedBlob.getFilename());
        this.addSecondaryBlobs(blobResults, otherDocConvertedBlobHolder, otherDocConvertedBlob.getFilename());
        return blobResults;
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean cachable() {
        return true;
    }

    public void setDefaultContentDiffFieldXPath(String xPath) {
        this.defaultFieldXPath = xPath;
    }

    protected String getMimeType(Blob blob) {
        if (blob == null) {
            return null;
        }
        String srcMT = blob.getMimeType();
        if (srcMT == null || srcMT.startsWith("application/octet-stream")) {
            try {
                MimetypeRegistry mtr = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
                srcMT = mtr.getMimetypeFromFilenameAndBlobWithDefault(blob.getFilename(), blob, "application/octet-stream");
                log.debug((Object)("mime type service returned " + srcMT));
            }
            catch (MimetypeDetectionException e) {
                log.warn((Object)"error while calling Mimetype service", (Throwable)e);
            }
        }
        return srcMT;
    }

    protected void setMimeType(BlobHolder result) {
        for (Blob blob : result.getBlobs()) {
            if (blob.getMimeType() != null || !blob.getFilename().endsWith("html")) continue;
            String mimeTpye = this.getMimeType(blob);
            blob.setMimeType(mimeTpye);
        }
    }

    protected String getDefaultContentDiffFieldXPath() {
        return this.defaultFieldXPath;
    }

    protected BlobHolder getConvertedBlobHolder(BlobHolder blobHolder, String converterName) throws ConversionException {
        if (converterName == null) {
            log.debug((Object)String.format("No converter parameter, using generic one: '%s'.", DEFAULT_CONVERTER_NAME));
            converterName = DEFAULT_CONVERTER_NAME;
        }
        BlobHolder convertedBlobHolder = this.getConversionService().convert(converterName, blobHolder, null);
        this.setMimeType(convertedBlobHolder);
        return convertedBlobHolder;
    }

    protected Blob getHtmlStringBlob(Blob blob) throws ContentDiffException {
        try {
            Blob htmlStringBlob = Blobs.createBlob((String)StringEscapeUtils.escapeHtml((String)new String(blob.getByteArray(), "UTF-8")).replace("\r\n", "\n").replace("\n", "<br />"));
            htmlStringBlob.setFilename(blob.getFilename());
            return htmlStringBlob;
        }
        catch (IOException ioe) {
            throw new ContentDiffException(String.format("Could not get string from blob %s", blob.getFilename()), ioe);
        }
    }

    protected void addSecondaryBlobs(List<Blob> blobResults, BlobHolder blobHolder, String mainBlobFilename) {
        for (Blob blob : blobHolder.getBlobs()) {
            String blobFilename = blob.getFilename();
            if (blobFilename == null || blobFilename.equals(mainBlobFilename)) continue;
            blobResults.add(blob);
        }
    }

    protected final ConversionService getConversionService() {
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        if (conversionService == null) {
            throw new NuxeoException("ConversionService service is null.");
        }
        return conversionService;
    }
}

