/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.diff.model;

public final class PropertyType {
    public static final String UNDEFINED = "undefined";
    public static final String STRING = "string";
    public static final String BOOLEAN = "boolean";
    public static final String DATE = "date";
    public static final String INTEGER = "integer";
    public static final String LONG = "long";
    public static final String DOUBLE = "double";
    public static final String CONTENT = "content";
    public static final String SCALAR_LIST = "scalarList";
    public static final String COMPLEX = "complex";
    public static final String COMPLEX_LIST = "complexList";
    public static final String CONTENT_LIST = "contentList";

    private PropertyType() {
    }

    public static boolean isSimpleType(String propertyType) {
        return !PropertyType.isListType(propertyType) && !PropertyType.isComplexType(propertyType) && !PropertyType.isContentType(propertyType);
    }

    public static boolean isListType(String propertyType) {
        return SCALAR_LIST.equals(propertyType) || COMPLEX_LIST.equals(propertyType) || CONTENT_LIST.equals(propertyType);
    }

    public static boolean isScalarListType(String propertyType) {
        return SCALAR_LIST.equals(propertyType);
    }

    public static boolean isComplexListType(String propertyType) {
        return COMPLEX_LIST.equals(propertyType);
    }

    public static boolean isContentListType(String propertyType) {
        return CONTENT_LIST.equals(propertyType);
    }

    public static boolean isComplexType(String propertyType) {
        return COMPLEX.equals(propertyType);
    }

    public static boolean isContentType(String propertyType) {
        return CONTENT.equals(propertyType);
    }
}

