/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.diff.pictures;

import java.io.File;

public class TempFilesHandler {
    protected static final String TEMP_DIR_PATH = System.getProperty("java.io.tmpdir");

    public static File prepareOrGetTempFolder(String leftDocId, String rightDocId) {
        String path = TEMP_DIR_PATH + "/" + leftDocId + rightDocId;
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdir();
        }
        return folder;
    }

    public static void deleteTempFolder(String leftDocId, String rightDocId) {
        File folder = TempFilesHandler.prepareOrGetTempFolder(leftDocId, rightDocId);
        if (folder != null && folder.exists() && folder.isDirectory()) {
            for (File f : folder.listFiles()) {
                f.delete();
            }
            folder.delete();
        }
    }
}

