/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.datadog.reporter;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.coursera.metrics.datadog.DatadogReporter;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="filter")
public class FilterDescriptor {
    @XNode(value="@method")
    protected String method;
    @XNodeList(value="includes/include", type=ArrayList.class, componentType=String.class)
    protected List<String> includes = new ArrayList<String>();
    @XNodeList(value="excludes/exclude", type=ArrayList.class, componentType=String.class)
    protected List<String> excludes = new ArrayList<String>();
    @XNodeList(value="expansions/expansion", type=ArrayList.class, componentType=String.class)
    protected List<String> expansions = new ArrayList<String>();

    public boolean getUseSubstringMatching() {
        return "substring".equals(this.method);
    }

    public boolean getUseRegexFilters() {
        return "regex".equals(this.method);
    }

    public ImmutableSet<String> getIncludes() {
        return ImmutableSet.builder().addAll(this.includes).build();
    }

    public ImmutableSet<String> getExcludes() {
        return ImmutableSet.builder().addAll(this.excludes).build();
    }

    public EnumSet<DatadogReporter.Expansion> getExpansions() {
        if (this.expansions.isEmpty()) {
            return DatadogReporter.Expansion.ALL;
        }
        return DatadogReporter.Expansion.ALL.stream().filter(e -> this.expansions.contains(e.toString())).collect(Collectors.toCollection(() -> EnumSet.noneOf(DatadogReporter.Expansion.class)));
    }
}

