/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.datadog.reporter;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.coursera.metrics.datadog.DatadogReporter;
import org.coursera.metrics.datadog.DefaultMetricNameFormatter;
import org.coursera.metrics.datadog.MetricNameFormatter;
import org.coursera.metrics.datadog.transport.HttpTransport;
import org.coursera.metrics.datadog.transport.Transport;
import org.nuxeo.datadog.reporter.DatadogReporterConfDescriptor;
import org.nuxeo.datadog.reporter.DatadogReporterService;
import org.nuxeo.datadog.reporter.DefaultStringMatchingStrategy;
import org.nuxeo.datadog.reporter.RegexStringMatchingStrategy;
import org.nuxeo.datadog.reporter.SubstringMatchingStrategy;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DatadogReporterServiceImpl
extends DefaultComponent
implements DatadogReporterService {
    private static final DefaultStringMatchingStrategy DEFAULT_STRING_MATCHING_STRATEGY = new DefaultStringMatchingStrategy();
    private static final RegexStringMatchingStrategy REGEX_STRING_MATCHING_STRATEGY = new RegexStringMatchingStrategy();
    private static final SubstringMatchingStrategy SUBSTRING_MATCHING_STRATEGY = new SubstringMatchingStrategy();
    protected final MetricRegistry metrics = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    private DatadogReporter reporter;
    private DatadogReporterConfDescriptor conf;
    private static final Log log = LogFactory.getLog(DatadogReporterService.class);

    public void start(ComponentContext context) {
        if (this.reporter != null) {
            this.startReporter();
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if ("configuration".equals(extensionPoint)) {
            this.setConfiguration((DatadogReporterConfDescriptor)contribution);
        }
    }

    private void setConfiguration(DatadogReporterConfDescriptor conf) {
        if (StringUtils.isBlank((CharSequence)conf.getApiKey())) {
            log.error((Object)"Datadog reporter service is not well configured : apiKey is empty. Your metrics won't be sent.");
        } else {
            this.conf = conf;
            this.buildReporter();
        }
    }

    private void buildReporter() {
        HttpTransport httpTransport = new HttpTransport.Builder().withApiKey(this.conf.getApiKey()).build();
        this.reporter = DatadogReporter.forRegistry((MetricRegistry)this.metrics).withHost(this.conf.getHost()).withTags(this.conf.getTags()).withTransport((Transport)httpTransport).withExpansions(this.getExpansions()).filter(this.getFilter()).withMetricNameFormatter((MetricNameFormatter)new DefaultMetricNameFormatter()).build();
    }

    private EnumSet<DatadogReporter.Expansion> getExpansions() {
        return this.conf.filter.getExpansions();
    }

    public MetricFilter getFilter() {
        RegexStringMatchingStrategy stringMatchingStrategy = this.conf.filter.getUseRegexFilters() ? REGEX_STRING_MATCHING_STRATEGY : (this.conf.filter.getUseSubstringMatching() ? SUBSTRING_MATCHING_STRATEGY : DEFAULT_STRING_MATCHING_STRATEGY);
        return (name, metric) -> !stringMatchingStrategy.containsMatch(this.conf.filter.getExcludes(), name) && (this.conf.filter.getIncludes().isEmpty() || stringMatchingStrategy.containsMatch(this.conf.filter.getIncludes(), name));
    }

    @Override
    public void startReporter() {
        if (this.reporter != null) {
            log.info((Object)"Starting Datadog reporter");
            this.reporter.start(this.conf.getPollInterval(), TimeUnit.SECONDS);
        }
    }

    @Override
    public void stopReporter() {
        log.info((Object)"Stopping Datadog reporter");
        this.reporter.stop();
    }

    DatadogReporter getReporter() {
        return this.reporter;
    }

    DatadogReporterConfDescriptor getConfig() {
        return this.conf;
    }
}

