/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.datadog.reporter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.datadog.reporter.FilterDescriptor;
import org.nuxeo.runtime.api.Framework;

@XObject(value="configuration")
public class DatadogReporterConfDescriptor {
    @XNode(value="apiKey")
    String apiKey;
    @XNode(value="pollInterval")
    int pollInterval;
    @XNode(value="host")
    String host;
    @XNode(value="tags")
    String tags;
    @XNode(value="filter")
    FilterDescriptor filter = new FilterDescriptor();

    public long getPollInterval() {
        return this.pollInterval;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getHost() {
        if (StringUtils.isNotBlank((CharSequence)this.host)) {
            return this.host;
        }
        return this.computeHostFromNuxeoUrl();
    }

    private String computeHostFromNuxeoUrl() {
        try {
            String url = Framework.getProperty((String)"nuxeo.url");
            if (StringUtils.isBlank((CharSequence)url)) {
                return "";
            }
            URI uri = new URI(url);
            String domain = uri.getHost();
            if (StringUtils.isBlank((CharSequence)domain)) {
                return "";
            }
            return domain.startsWith("www.") ? domain.substring(4) : domain;
        }
        catch (URISyntaxException e) {
            return "";
        }
    }

    public List<String> getTags() {
        if (StringUtils.isBlank((CharSequence)this.tags)) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String tag : Arrays.asList(this.tags.split(","))) {
            result.add(tag.trim());
        }
        return result;
    }
}

