/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.datadog.reporter;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;

@XObject(value="configuration")
public class DatadogReporterConfDescriptor {
    @XNode(value="apiKey")
    String apiKey;
    @XNode(value="pollInterval")
    int pollInterval;
    @XNode(value="host")
    String host;

    public long getPollInterval() {
        return this.pollInterval;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getHost() {
        if (StringUtils.isNotBlank((String)this.host)) {
            return this.host;
        }
        return this.computeHostFromNuxeoUrl();
    }

    private String computeHostFromNuxeoUrl() {
        try {
            String url = Framework.getProperty((String)"nuxeo.url");
            if (StringUtils.isBlank((String)url)) {
                return "";
            }
            URI uri = new URI(url);
            String domain = uri.getHost();
            if (StringUtils.isBlank((String)domain)) {
                return "";
            }
            return domain.startsWith("www.") ? domain.substring(4) : domain;
        }
        catch (URISyntaxException e) {
            return "";
        }
    }
}

