/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.magick.utils;

import java.awt.Point;
import java.io.File;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.magick.MagickExecutor;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageIdentifier;
import org.nuxeo.runtime.api.Framework;

public class ImageResizer
extends MagickExecutor {
    public static final int MAX_JEPG_DIMENSION = 65500;

    public static ImageInfo resize(String inputFile, String outputFile, int targetWidth, int targetHeight, int targetDepth) throws CommandNotAvailable, CommandException {
        ExecResult res;
        if (targetDepth == -1) {
            targetDepth = ImageIdentifier.getInfo(inputFile).getDepth();
        }
        CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        CmdParameters params = cles.getDefaultCmdParameters();
        params.addNamedParameter("targetWidth", String.valueOf(targetWidth));
        params.addNamedParameter("targetHeight", String.valueOf(targetHeight));
        params.addNamedParameter("inputFilePath", inputFile);
        params.addNamedParameter("outputFilePath", outputFile);
        params.addNamedParameter("targetDepth", String.valueOf(targetDepth));
        String commandName = "resizer";
        if (outputFile.endsWith("jpg")) {
            commandName = "jpegResizer";
            Point size = ImageResizer.scaleToMax(targetWidth, targetHeight, 65500);
            if (size != null) {
                params.addNamedParameter("targetWidth", String.valueOf(size.getX()));
                params.addNamedParameter("targetHeight", String.valueOf(size.getY()));
            }
        }
        if (!(res = cles.execCommand(commandName, params)).isSuccessful()) {
            throw res.getError();
        }
        if (new File(outputFile).exists()) {
            return ImageIdentifier.getInfo(outputFile);
        }
        return null;
    }

    public static Point scaleToMax(int width, int height, int max) {
        if (max > 0 && (width > max || height > max)) {
            float maxSide = Math.max(width, height);
            float ratio = maxSide / (float)max;
            return new Point(Math.round((float)width / ratio), Math.round((float)height / ratio));
        }
        return null;
    }
}

