/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.operation;

import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.adapters.MultiviewPicture;

@Operation(id="Picture.GetView", category="Conversion", label="Get image view", description="Get an image from a Picture document.", aliases={"Picture.getView"})
public class GetPictureView {
    public static final String ID = "Picture.GetView";
    @Param(name="viewName", required=false)
    protected String viewName;

    @OperationMethod
    public Blob run(DocumentModel doc) {
        PictureView pv;
        MultiviewPicture mvp = (MultiviewPicture)doc.getAdapter(MultiviewPicture.class);
        if (mvp == null) {
            return null;
        }
        if (this.viewName == null) {
            this.viewName = mvp.getOrigin();
        }
        if ((pv = mvp.getView(this.viewName)) == null) {
            return null;
        }
        return pv.getBlob();
    }
}

