/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.util;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.NodeProcessor;

public class Visitor {
    private final NodeProcessor processor;
    private boolean processing = true;
    private boolean partialVisit = false;
    private Node startNode;
    private Node endNode;

    public Visitor(NodeProcessor visitor) {
        this.processor = visitor;
    }

    public void process(Node node) {
        this.visit(node);
    }

    public void process(Document document) {
        this.visit((Node)document);
    }

    public void process(Node startNode, Node endNode) {
        this.processing = false;
        this.partialVisit = true;
        this.startNode = startNode;
        this.endNode = endNode;
        this.visit((Node)startNode.getOwnerDocument());
    }

    public void visit(Node node) {
        if (this.startNode == node) {
            this.processing = true;
        } else if (this.endNode == node) {
            this.processing = false;
        }
        if (this.processor.doBreak()) {
            return;
        }
        NodeList list = node.getChildNodes();
        if (list == null || list.getLength() == 0) {
            this.processIf(node);
        } else {
            int x;
            int length = list.getLength();
            Node[] nodes = new Node[list.getLength()];
            for (x = 0; x < length; ++x) {
                nodes[x] = list.getItem(x);
            }
            this.processIf(node);
            for (x = 0; x < length; ++x) {
                this.visit(nodes[x]);
            }
        }
    }

    private void processIf(Node node) {
        if (this.processing || !this.partialVisit) {
            this.processor.process(node);
        }
    }
}

