/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.core.im;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandException;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.picture.core.ImageUtils;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageConverter;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageCropper;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageIdentifier;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageResizer;
import org.nuxeo.ecm.platform.picture.magick.utils.ImageRotater;
import org.nuxeo.runtime.api.Framework;

public class IMImageUtils
implements ImageUtils {
    private static final Log log = LogFactory.getLog(IMImageUtils.class);

    @Override
    public Blob crop(Blob blob, final int x, final int y, final int width, final int height) {
        return new ImageMagickCaller(){

            @Override
            public void callImageMagick() throws CommandNotAvailable, CommandException {
                ImageCropper.crop(this.sourceFile.getAbsolutePath(), this.targetFile.getAbsolutePath(), width, height, x, y);
            }
        }.call(blob, null, "resizer");
    }

    @Override
    public Blob resize(Blob blob, String finalFormat, final int width, final int height, final int depth) {
        return new ImageMagickCaller(){

            @Override
            public void callImageMagick() throws CommandNotAvailable, CommandException {
                ImageResizer.resize(this.sourceFile.getAbsolutePath(), this.targetFile.getAbsolutePath(), width, height, depth);
            }
        }.call(blob, finalFormat, "resizer");
    }

    @Override
    public Blob rotate(Blob blob, final int angle) {
        return new ImageMagickCaller(){

            @Override
            public void callImageMagick() throws CommandNotAvailable, CommandException {
                ImageRotater.rotate(this.sourceFile.getAbsolutePath(), this.targetFile.getAbsolutePath(), angle);
            }
        }.call(blob, null, "rotate");
    }

    @Override
    public Blob convertToPDF(Blob blob) {
        return new ImageMagickCaller(){

            @Override
            public void callImageMagick() throws CommandNotAvailable, CommandException {
                ImageConverter.convert(this.sourceFile.getAbsolutePath(), this.targetFile.getAbsolutePath());
            }
        }.call(blob, "pdf", "converter");
    }

    @Override
    public boolean isAvailable() {
        CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        CommandAvailability commandAvailability = cles.getCommandAvailability("identify");
        return commandAvailability.isAvailable();
    }

    public static abstract class ImageMagickCaller {
        protected File sourceFile;
        protected File tmpFile;
        protected File targetFile;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Blob call(Blob blob, String targetExt, String commandName) {
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
            CommandAvailability availability = cles.getCommandAvailability(commandName);
            if (!availability.isAvailable()) {
                return null;
            }
            try {
                this.makeFiles(blob, targetExt);
                this.callImageMagick();
                Blob targetBlob = Blobs.createBlob((File)this.targetFile);
                Framework.trackFile((File)this.targetFile, (Object)targetBlob);
                Blob blob2 = targetBlob;
                return blob2;
            }
            catch (IOException | CommandException | CommandNotAvailable e) {
                log.error((Object)("ImageMagick failed on command: " + commandName), e);
                Blob blob3 = null;
                return blob3;
            }
            finally {
                if (this.tmpFile != null) {
                    this.tmpFile.delete();
                }
            }
        }

        protected void makeFiles(Blob blob, String targetExt) throws CommandNotAvailable, CommandException, IOException {
            this.sourceFile = blob.getFile();
            String ext = FilenameUtils.getExtension((String)blob.getFilename());
            if (ext == null || "".equals(ext)) {
                if (this.sourceFile == null) {
                    this.sourceFile = this.createTempSource(blob, "tmp");
                }
                ext = ImageIdentifier.getInfo(this.sourceFile.getPath()).getFormat();
                if (this.tmpFile == null) {
                    this.sourceFile = this.createTempSource(blob, ext);
                } else {
                    File newTmpFile = new File(FilenameUtils.removeExtension((String)this.tmpFile.getPath()) + "." + ext);
                    this.tmpFile.renameTo(newTmpFile);
                    this.tmpFile = newTmpFile;
                    this.sourceFile = newTmpFile;
                }
            } else if (this.sourceFile != null && !ext.equals(FilenameUtils.getExtension((String)this.sourceFile.getName()))) {
                this.sourceFile = null;
            }
            if (this.sourceFile == null) {
                this.sourceFile = this.createTempSource(blob, ext);
            }
            if (targetExt == null) {
                targetExt = ext;
            }
            this.targetFile = Framework.createTempFile((String)"nuxeoImageTarget", (String)("." + targetExt));
        }

        protected File createTempSource(Blob blob, String ext) throws IOException {
            this.tmpFile = Framework.createTempFile((String)"nuxeoImageSource", (String)("." + ext));
            blob.transferTo(this.tmpFile);
            return this.tmpFile;
        }

        public abstract void callImageMagick() throws CommandNotAvailable, CommandException;
    }
}

