/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.runtime.api.Framework;

public class PictureViewsGenerationWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    public static final String CATEGORY_PICTURE_GENERATION = "pictureViewsGeneration";
    public static final String PICTURE_VIEWS_GENERATION_DONE_EVENT = "pictureViewsGenerationDone";
    protected final String xpath;

    public PictureViewsGenerationWork(String repositoryName, String docId, String xpath) {
        super(repositoryName + ':' + docId + ':' + xpath + ":pictureView");
        this.setDocument(repositoryName, docId);
        this.xpath = xpath;
    }

    public String getCategory() {
        return CATEGORY_PICTURE_GENERATION;
    }

    public String getTitle() {
        return "Picture views generation";
    }

    public int getRetryCount() {
        return 2;
    }

    public void work() {
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.setStatus("Extracting");
        this.openSystemSession();
        if (!this.session.exists((DocumentRef)new IdRef(this.docId))) {
            this.setStatus("Nothing to process");
            return;
        }
        DocumentModel workingDocument = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        Property fileProp = workingDocument.getProperty(this.xpath);
        Blob blob = (Blob)fileProp.getValue();
        if (blob == null) {
            return;
        }
        String title = workingDocument.getTitle();
        this.setStatus("Generating views");
        try {
            PictureResourceAdapter picture = (PictureResourceAdapter)workingDocument.getAdapter(PictureResourceAdapter.class);
            picture.fillPictureViews(blob, blob.getFilename(), title, null);
        }
        catch (DocumentNotFoundException e) {
            this.setStatus("Nothing to process");
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!this.session.exists((DocumentRef)new IdRef(this.docId))) {
            this.setStatus("Nothing to process");
            return;
        }
        this.setStatus("Saving");
        if (workingDocument.isVersion()) {
            workingDocument.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        workingDocument.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
        workingDocument.putContextData("disablePictureViewsGenerationListener", (Serializable)Boolean.TRUE);
        this.session.saveDocument(workingDocument);
        this.firePictureViewsGenerationDoneEvent(workingDocument);
        this.setStatus("Done");
    }

    protected void firePictureViewsGenerationDoneEvent(DocumentModel doc) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        List workIds = workManager.listWorkIds(CATEGORY_PICTURE_GENERATION, null);
        int worksCount = 0;
        for (String workId : workIds) {
            if (!workId.equals(this.getId()) || ++worksCount <= 1) continue;
            return;
        }
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), doc);
        Event event = ctx.newEvent(PICTURE_VIEWS_GENERATION_DONE_EVENT);
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
    }
}

