/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTiles;
import org.nuxeo.ecm.platform.pictures.tiles.serializer.PictureTilesSerializer;

public class JSONPictureTilesSerializer
implements PictureTilesSerializer {
    @Override
    public String serialize(PictureTiles tiles) {
        LinkedHashMap mainMap = new LinkedHashMap();
        LinkedHashMap<String, Number> tileInfo = new LinkedHashMap<String, Number>();
        tileInfo.put("maxtiles", tiles.getMaxTiles());
        tileInfo.put("xtiles", tiles.getXTiles());
        tileInfo.put("ytiles", tiles.getYTiles());
        tileInfo.put("tileWidth", tiles.getTilesWidth());
        tileInfo.put("tileHeight", tiles.getTilesHeight());
        tileInfo.put("zoom", Float.valueOf(tiles.getZoomfactor()));
        mainMap.put("tileInfo", tileInfo);
        LinkedHashMap<String, Object> orgImgInfo = new LinkedHashMap<String, Object>();
        orgImgInfo.put("format", tiles.getOriginalImageInfo().getFormat());
        orgImgInfo.put("width", tiles.getOriginalImageInfo().getWidth());
        orgImgInfo.put("height", tiles.getOriginalImageInfo().getHeight());
        mainMap.put("originalImage", orgImgInfo);
        LinkedHashMap<String, Object> srcImgInfo = new LinkedHashMap<String, Object>();
        srcImgInfo.put("format", tiles.getSourceImageInfo().getFormat());
        srcImgInfo.put("width", tiles.getSourceImageInfo().getWidth());
        srcImgInfo.put("height", tiles.getSourceImageInfo().getHeight());
        mainMap.put("srcImage", srcImgInfo);
        LinkedHashMap<String, String> otherInfo = new LinkedHashMap<String, String>();
        for (String k : tiles.getInfo().keySet()) {
            otherInfo.put(k, tiles.getInfo().get(k));
        }
        mainMap.put("additionalInfo", otherInfo);
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(mainMap);
        }
        catch (JsonProcessingException e) {
            throw new NuxeoException("Unable to serialize tile", (Throwable)e);
        }
    }
}

