/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.DragEndEvent;
import com.google.gwt.event.dom.client.DragEndHandler;
import com.google.gwt.event.dom.client.DragEnterEvent;
import com.google.gwt.event.dom.client.DragEnterHandler;
import com.google.gwt.event.dom.client.DragEvent;
import com.google.gwt.event.dom.client.DragHandler;
import com.google.gwt.event.dom.client.DragLeaveEvent;
import com.google.gwt.event.dom.client.DragLeaveHandler;
import com.google.gwt.event.dom.client.DragOverEvent;
import com.google.gwt.event.dom.client.DragOverHandler;
import com.google.gwt.event.dom.client.DragStartEvent;
import com.google.gwt.event.dom.client.DragStartHandler;
import com.google.gwt.event.dom.client.DropEvent;
import com.google.gwt.event.dom.client.DropHandler;
import com.google.gwt.event.dom.client.HasAllDragAndDropHandlers;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasDoubleClickHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.impl.ElementMapperImpl;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SourcesTableEvents;
import com.google.gwt.user.client.ui.TableListener;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class HTMLTable
extends Panel
implements SourcesTableEvents,
HasAllDragAndDropHandlers,
HasClickHandlers,
HasDoubleClickHandlers {
    private static final HTMLTableImpl impl = (HTMLTableImpl)GWT.create(HTMLTableImpl.class);
    private final com.google.gwt.dom.client.Element bodyElem;
    private CellFormatter cellFormatter;
    private ColumnFormatter columnFormatter;
    private RowFormatter rowFormatter;
    private final com.google.gwt.dom.client.Element tableElem;
    private ElementMapperImpl<Widget> widgetMap = new ElementMapperImpl();

    public HTMLTable() {
        this.tableElem = DOM.createTable();
        this.bodyElem = DOM.createTBody();
        DOM.appendChild(this.tableElem, this.bodyElem);
        this.setElement(this.tableElem);
    }

    @Override
    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.addDomHandler(handler, ClickEvent.getType());
    }

    @Override
    public HandlerRegistration addDoubleClickHandler(DoubleClickHandler handler) {
        return this.addDomHandler(handler, DoubleClickEvent.getType());
    }

    @Override
    public HandlerRegistration addDragEndHandler(DragEndHandler handler) {
        return this.addBitlessDomHandler(handler, DragEndEvent.getType());
    }

    @Override
    public HandlerRegistration addDragEnterHandler(DragEnterHandler handler) {
        return this.addBitlessDomHandler(handler, DragEnterEvent.getType());
    }

    @Override
    public HandlerRegistration addDragHandler(DragHandler handler) {
        return this.addBitlessDomHandler(handler, DragEvent.getType());
    }

    @Override
    public HandlerRegistration addDragLeaveHandler(DragLeaveHandler handler) {
        return this.addBitlessDomHandler(handler, DragLeaveEvent.getType());
    }

    @Override
    public HandlerRegistration addDragOverHandler(DragOverHandler handler) {
        return this.addBitlessDomHandler(handler, DragOverEvent.getType());
    }

    @Override
    public HandlerRegistration addDragStartHandler(DragStartHandler handler) {
        return this.addBitlessDomHandler(handler, DragStartEvent.getType());
    }

    @Override
    public HandlerRegistration addDropHandler(DropHandler handler) {
        return this.addBitlessDomHandler(handler, DropEvent.getType());
    }

    @Override
    @Deprecated
    public void addTableListener(TableListener listener) {
        ListenerWrapper.WrappedTableListener.add(this, listener);
    }

    @Override
    public void clear() {
        this.clear(false);
    }

    public void clear(boolean clearInnerHTML) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int col = 0; col < this.getCellCount(row); ++col) {
                this.cleanCell(row, col, clearInnerHTML);
            }
        }
    }

    public boolean clearCell(int row, int column) {
        Element td = this.getCellFormatter().getElement(row, column);
        return this.internalClearCell((com.google.gwt.dom.client.Element)td, true);
    }

    public abstract int getCellCount(int var1);

    public Cell getCellForEvent(ClickEvent event) {
        Element td = this.getEventTargetCell(Event.as(event.getNativeEvent()));
        if (td == null) {
            return null;
        }
        int row = TableRowElement.as(td.getParentElement()).getSectionRowIndex();
        int column = TableCellElement.as(td).getCellIndex();
        return new Cell(row, column);
    }

    public CellFormatter getCellFormatter() {
        return this.cellFormatter;
    }

    public int getCellPadding() {
        return this.tableElem.getPropertyInt("cellPadding");
    }

    public int getCellSpacing() {
        return this.tableElem.getPropertyInt("cellSpacing");
    }

    public ColumnFormatter getColumnFormatter() {
        return this.columnFormatter;
    }

    public String getHTML(int row, int column) {
        return this.cellFormatter.getElement(row, column).getInnerHTML();
    }

    public abstract int getRowCount();

    public RowFormatter getRowFormatter() {
        return this.rowFormatter;
    }

    public String getText(int row, int column) {
        this.checkCellBounds(row, column);
        Element e = this.cellFormatter.getElement(row, column);
        return e.getInnerText();
    }

    public Widget getWidget(int row, int column) {
        this.checkCellBounds(row, column);
        return this.getWidgetImpl(row, column);
    }

    public boolean isCellPresent(int row, int column) {
        if (row >= this.getRowCount() || row < 0) {
            return false;
        }
        return column >= 0 && column < this.getCellCount(row);
    }

    @Override
    public Iterator<Widget> iterator() {
        return new Iterator<Widget>(){
            final ArrayList<Widget> widgetList;
            int lastIndex;
            int nextIndex;
            {
                this.widgetList = HTMLTable.this.widgetMap.getObjectList();
                this.lastIndex = -1;
                this.nextIndex = -1;
                this.findNext();
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex < this.widgetList.size();
            }

            @Override
            public Widget next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Widget result = this.widgetList.get(this.nextIndex);
                this.lastIndex = this.nextIndex;
                this.findNext();
                return result;
            }

            @Override
            public void remove() {
                if (this.lastIndex < 0) {
                    throw new IllegalStateException();
                }
                Widget w = this.widgetList.get(this.lastIndex);
                assert (w.getParent() instanceof HTMLTable);
                w.removeFromParent();
                this.lastIndex = -1;
            }

            private void findNext() {
                while (++this.nextIndex < this.widgetList.size()) {
                    if (this.widgetList.get(this.nextIndex) == null) continue;
                    return;
                }
            }
        };
    }

    @Override
    public boolean remove(Widget widget) {
        if (widget.getParent() != this) {
            return false;
        }
        try {
            this.orphan(widget);
        }
        finally {
            Element elem = widget.getElement();
            DOM.getParent(elem).removeChild(elem);
            this.widgetMap.removeByElement(elem);
        }
        return true;
    }

    @Override
    @Deprecated
    public void removeTableListener(TableListener listener) {
        ListenerWrapper.WrappedTableListener.remove(this, listener);
    }

    public void setBorderWidth(int width) {
        this.tableElem.setPropertyString("border", "" + width);
    }

    public void setCellPadding(int padding) {
        this.tableElem.setPropertyInt("cellPadding", padding);
    }

    public void setCellSpacing(int spacing) {
        this.tableElem.setPropertyInt("cellSpacing", spacing);
    }

    public void setHTML(int row, int column, String html) {
        this.prepareCell(row, column);
        com.google.gwt.dom.client.Element td = this.cleanCell(row, column, html == null);
        if (html != null) {
            td.setInnerHTML(html);
        }
    }

    public void setHTML(int row, int column, SafeHtml html) {
        this.setHTML(row, column, html.asString());
    }

    public void setText(int row, int column, String text) {
        this.prepareCell(row, column);
        com.google.gwt.dom.client.Element td = this.cleanCell(row, column, text == null);
        if (text != null) {
            td.setInnerText(text);
        }
    }

    public void setWidget(int row, int column, Widget widget) {
        this.prepareCell(row, column);
        com.google.gwt.dom.client.Element td = this.cleanCell(row, column, true);
        if (widget != null) {
            widget.removeFromParent();
            this.widgetMap.put(widget);
            DOM.appendChild(td, widget.getElement());
            this.adopt(widget);
        }
    }

    public void setWidget(int row, int column, IsWidget widget) {
        this.setWidget(row, column, HTMLTable.asWidgetOrNull(widget));
    }

    protected void checkCellBounds(int row, int column) {
        this.checkRowBounds(row);
        if (column < 0) {
            throw new IndexOutOfBoundsException("Column " + column + " must be non-negative: " + column);
        }
        int cellSize = this.getCellCount(row);
        if (cellSize <= column) {
            throw new IndexOutOfBoundsException("Column index: " + column + ", Column size: " + this.getCellCount(row));
        }
    }

    protected void checkRowBounds(int row) {
        int rowSize = this.getRowCount();
        if (row >= rowSize || row < 0) {
            throw new IndexOutOfBoundsException("Row index: " + row + ", Row size: " + rowSize);
        }
    }

    protected Element createCell() {
        return DOM.createTD();
    }

    protected Element getBodyElement() {
        return DOM.asOld(this.bodyElem);
    }

    protected int getDOMCellCount(com.google.gwt.dom.client.Element tableBody, int row) {
        return this.getDOMCellCount(DOM.asOld(tableBody), row);
    }

    @Deprecated
    protected int getDOMCellCount(Element tableBody, int row) {
        com.google.gwt.dom.client.Element rowElement = impl.getRows(tableBody).get(row);
        return impl.getCells(rowElement).length();
    }

    protected int getDOMCellCount(int row) {
        return this.getDOMCellCount(this.bodyElem, row);
    }

    protected int getDOMRowCount() {
        return this.getDOMRowCount(this.bodyElem);
    }

    protected int getDOMRowCount(com.google.gwt.dom.client.Element tbody) {
        return this.getDOMRowCount(DOM.asOld(tbody));
    }

    @Deprecated
    protected int getDOMRowCount(Element tbody) {
        return impl.getRows(tbody).length();
    }

    protected Element getEventTargetCell(Event event) {
        Element td = DOM.eventGetTarget(event);
        while (td != null) {
            Element tr;
            Element body;
            if (td.getPropertyString("tagName").equalsIgnoreCase("td") && (body = DOM.getParent(tr = DOM.getParent(td))) == this.bodyElem) {
                return DOM.asOld(td);
            }
            if (td == this.bodyElem) {
                return null;
            }
            td = DOM.getParent(td);
        }
        return null;
    }

    protected void insertCell(int row, int column) {
        Element tr = this.rowFormatter.getRow(this.bodyElem, row);
        Element td = this.createCell();
        DOM.insertChild(tr, td, column);
    }

    protected void insertCells(int row, int column, int count) {
        Element tr = this.rowFormatter.getRow(this.bodyElem, row);
        for (int i = column; i < column + count; ++i) {
            Element td = this.createCell();
            DOM.insertChild(tr, td, i);
        }
    }

    protected int insertRow(int beforeRow) {
        if (beforeRow != this.getRowCount()) {
            this.checkRowBounds(beforeRow);
        }
        Element tr = DOM.createTR();
        DOM.insertChild(this.bodyElem, tr, beforeRow);
        return beforeRow;
    }

    protected boolean internalClearCell(com.google.gwt.dom.client.Element td, boolean clearInnerHTML) {
        return this.internalClearCell(DOM.asOld(td), clearInnerHTML);
    }

    @Deprecated
    protected boolean internalClearCell(Element td, boolean clearInnerHTML) {
        Element maybeChild = DOM.getFirstChild(td);
        Widget widget = null;
        if (maybeChild != null) {
            widget = this.widgetMap.get(maybeChild);
        }
        if (widget != null) {
            this.remove(widget);
            return true;
        }
        if (clearInnerHTML) {
            td.setInnerHTML("");
        }
        return false;
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        int rowCount = this.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            int cellCount = this.getCellCount(row);
            for (int cell = 0; cell < cellCount; ++cell) {
                com.google.gwt.dom.client.Element cellElem = this.cellFormatter.getRawElement(row, cell);
                HTMLTable.ensureDebugId(cellElem, baseID, row + "-" + cell);
            }
        }
    }

    protected abstract void prepareCell(int var1, int var2);

    protected void prepareColumn(int column) {
        if (column < 0) {
            throw new IndexOutOfBoundsException("Cannot access a column with a negative index: " + column);
        }
    }

    protected abstract void prepareRow(int var1);

    protected void removeCell(int row, int column) {
        this.checkCellBounds(row, column);
        com.google.gwt.dom.client.Element td = this.cleanCell(row, column, false);
        Element tr = this.rowFormatter.getRow(this.bodyElem, row);
        tr.removeChild(td);
    }

    protected void removeRow(int row) {
        int columnCount = this.getCellCount(row);
        for (int column = 0; column < columnCount; ++column) {
            this.cleanCell(row, column, false);
        }
        this.bodyElem.removeChild(this.rowFormatter.getRow(this.bodyElem, row));
    }

    protected void setCellFormatter(CellFormatter cellFormatter) {
        this.cellFormatter = cellFormatter;
    }

    protected void setColumnFormatter(ColumnFormatter formatter) {
        if (this.columnFormatter != null) {
            formatter.columnGroup = this.columnFormatter.columnGroup;
        }
        this.columnFormatter = formatter;
        this.columnFormatter.prepareColumnGroup();
    }

    protected void setRowFormatter(RowFormatter rowFormatter) {
        this.rowFormatter = rowFormatter;
    }

    void addCells(com.google.gwt.dom.client.Element tbody, int row, int num) {
        com.google.gwt.dom.client.Element rowElem = impl.getRows(tbody).get(row);
        for (int i = 0; i < num; ++i) {
            TableCellElement tdElement = Document.get().createTDElement();
            rowElem.appendChild(tdElement);
        }
    }

    private com.google.gwt.dom.client.Element cleanCell(int row, int column, boolean clearInnerHTML) {
        com.google.gwt.dom.client.Element td = this.getCellFormatter().getRawElement(row, column);
        this.internalClearCell(td, clearInnerHTML);
        return td;
    }

    private Widget getWidgetImpl(int row, int column) {
        com.google.gwt.dom.client.Element e = this.cellFormatter.getRawElement(row, column);
        Element child = DOM.getFirstChild(e);
        if (child == null) {
            return null;
        }
        return this.widgetMap.get(child);
    }

    public class RowFormatter {
        public void addStyleName(int row, String styleName) {
            UIObject.setStyleName(this.ensureElement(row), styleName, true);
        }

        public Element getElement(int row) {
            HTMLTable.this.checkRowBounds(row);
            return DOM.asOld(this.getRow(HTMLTable.this.bodyElem, row));
        }

        public String getStyleName(int row) {
            return UIObject.getStyleName(this.getElement(row));
        }

        public String getStylePrimaryName(int row) {
            return UIObject.getStylePrimaryName(this.getElement(row));
        }

        public boolean isVisible(int row) {
            Element e = this.getElement(row);
            return UIObject.isVisible(e);
        }

        public void removeStyleName(int row, String styleName) {
            UIObject.setStyleName(this.ensureElement(row), styleName, false);
        }

        public void setStyleName(int row, String styleName) {
            UIObject.setStyleName(this.ensureElement(row), styleName);
        }

        public void setStylePrimaryName(int row, String styleName) {
            UIObject.setStylePrimaryName(this.ensureElement(row), styleName);
        }

        public void setVerticalAlign(int row, HasVerticalAlignment.VerticalAlignmentConstant align) {
            this.ensureElement(row).getStyle().setProperty("verticalAlign", align.getVerticalAlignString());
        }

        public void setVisible(int row, boolean visible) {
            Element e = this.ensureElement(row);
            UIObject.setVisible(e, visible);
        }

        protected Element ensureElement(int row) {
            HTMLTable.this.prepareRow(row);
            return DOM.asOld(this.getRow(HTMLTable.this.bodyElem, row));
        }

        protected Element getRow(com.google.gwt.dom.client.Element tbody, int row) {
            return this.getRow(DOM.asOld(tbody), row);
        }

        @Deprecated
        protected Element getRow(Element tbody, int row) {
            return DOM.asOld(impl.getRows(tbody).get(row));
        }

        protected void setAttr(int row, String attrName, String value) {
            Element elem = this.ensureElement(row);
            elem.setAttribute(attrName, value);
        }
    }

    public class ColumnFormatter {
        protected com.google.gwt.dom.client.Element columnGroup;

        public void addStyleName(int col, String styleName) {
            UIObject.setStyleName(this.ensureColumn(col), styleName, true);
        }

        public Element getElement(int column) {
            return DOM.asOld(this.ensureColumn(column));
        }

        public String getStyleName(int column) {
            return UIObject.getStyleName(this.ensureColumn(column));
        }

        public String getStylePrimaryName(int column) {
            return UIObject.getStylePrimaryName(this.ensureColumn(column));
        }

        public void removeStyleName(int column, String styleName) {
            UIObject.setStyleName(this.ensureColumn(column), styleName, false);
        }

        public void setStyleName(int column, String styleName) {
            UIObject.setStyleName(this.ensureColumn(column), styleName);
        }

        public void setStylePrimaryName(int column, String styleName) {
            UIObject.setStylePrimaryName(this.ensureColumn(column), styleName);
        }

        public void setWidth(int column, String width) {
            this.ensureColumn(column).setPropertyString("width", width);
        }

        void resizeColumnGroup(int columns, boolean growOnly) {
            block3: {
                int num;
                block2: {
                    columns = Math.max(columns, 1);
                    num = this.columnGroup.getChildCount();
                    if (num >= columns) break block2;
                    for (int i = num; i < columns; ++i) {
                        this.columnGroup.appendChild(Document.get().createColElement());
                    }
                    break block3;
                }
                if (growOnly || num <= columns) break block3;
                for (int i = num; i > columns; --i) {
                    this.columnGroup.removeChild(this.columnGroup.getLastChild());
                }
            }
        }

        private com.google.gwt.dom.client.Element ensureColumn(int col) {
            HTMLTable.this.prepareColumn(col);
            this.prepareColumnGroup();
            this.resizeColumnGroup(col + 1, true);
            return (com.google.gwt.dom.client.Element)this.columnGroup.getChild(col).cast();
        }

        private void prepareColumnGroup() {
            if (this.columnGroup == null) {
                this.columnGroup = DOM.createElement("colgroup");
                DOM.insertChild(HTMLTable.this.tableElem, this.columnGroup, 0);
                DOM.appendChild(this.columnGroup, DOM.createElement("col"));
            }
        }
    }

    public class CellFormatter {
        public void addStyleName(int row, int column, String styleName) {
            HTMLTable.this.prepareCell(row, column);
            com.google.gwt.dom.client.Element td = this.getCellElement(HTMLTable.this.bodyElem, row, column);
            UIObject.setStyleName(td, styleName, true);
        }

        public Element getElement(int row, int column) {
            HTMLTable.this.checkCellBounds(row, column);
            return DOM.asOld(this.getCellElement(HTMLTable.this.bodyElem, row, column));
        }

        public String getStyleName(int row, int column) {
            return UIObject.getStyleName(this.getElement(row, column));
        }

        public String getStylePrimaryName(int row, int column) {
            return UIObject.getStylePrimaryName(this.getElement(row, column));
        }

        public boolean isVisible(int row, int column) {
            Element e = this.getElement(row, column);
            return UIObject.isVisible(e);
        }

        public void removeStyleName(int row, int column, String styleName) {
            HTMLTable.this.checkCellBounds(row, column);
            com.google.gwt.dom.client.Element td = this.getCellElement(HTMLTable.this.bodyElem, row, column);
            UIObject.setStyleName(td, styleName, false);
        }

        public void setAlignment(int row, int column, HasHorizontalAlignment.HorizontalAlignmentConstant hAlign, HasVerticalAlignment.VerticalAlignmentConstant vAlign) {
            this.setHorizontalAlignment(row, column, hAlign);
            this.setVerticalAlignment(row, column, vAlign);
        }

        public void setHeight(int row, int column, String height) {
            HTMLTable.this.prepareCell(row, column);
            com.google.gwt.dom.client.Element elem = this.getCellElement(HTMLTable.this.bodyElem, row, column);
            elem.setPropertyString("height", height);
        }

        public void setHorizontalAlignment(int row, int column, HasHorizontalAlignment.HorizontalAlignmentConstant align) {
            HTMLTable.this.prepareCell(row, column);
            com.google.gwt.dom.client.Element elem = this.getCellElement(HTMLTable.this.bodyElem, row, column);
            elem.setPropertyString("align", align.getTextAlignString());
        }

        public void setStyleName(int row, int column, String styleName) {
            HTMLTable.this.prepareCell(row, column);
            UIObject.setStyleName(this.getCellElement(HTMLTable.this.bodyElem, row, column), styleName);
        }

        public void setStylePrimaryName(int row, int column, String styleName) {
            UIObject.setStylePrimaryName(this.getCellElement(HTMLTable.this.bodyElem, row, column), styleName);
        }

        public void setVerticalAlignment(int row, int column, HasVerticalAlignment.VerticalAlignmentConstant align) {
            HTMLTable.this.prepareCell(row, column);
            this.getCellElement(HTMLTable.this.bodyElem, row, column).getStyle().setProperty("verticalAlign", align.getVerticalAlignString());
        }

        public void setVisible(int row, int column, boolean visible) {
            Element e = this.ensureElement(row, column);
            UIObject.setVisible(e, visible);
        }

        public void setWidth(int row, int column, String width) {
            HTMLTable.this.prepareCell(row, column);
            this.getCellElement(HTMLTable.this.bodyElem, row, column).setPropertyString("width", width);
        }

        public void setWordWrap(int row, int column, boolean wrap) {
            HTMLTable.this.prepareCell(row, column);
            String wrapValue = wrap ? "" : "nowrap";
            this.getElement(row, column).getStyle().setProperty("whiteSpace", wrapValue);
        }

        protected Element ensureElement(int row, int column) {
            HTMLTable.this.prepareCell(row, column);
            return DOM.asOld(this.getCellElement(HTMLTable.this.bodyElem, row, column));
        }

        protected String getAttr(int row, int column, String attr) {
            Element elem = this.getElement(row, column);
            return elem.getAttribute(attr);
        }

        protected void setAttr(int row, int column, String attrName, String value) {
            Element elem = this.ensureElement(row, column);
            elem.setAttribute(attrName, value);
        }

        private com.google.gwt.dom.client.Element getCellElement(com.google.gwt.dom.client.Element tbody, int row, int col) {
            return impl.getCells(impl.getRows(tbody).get(row)).get(col);
        }

        private com.google.gwt.dom.client.Element getRawElement(int row, int column) {
            return this.getCellElement(HTMLTable.this.bodyElem, row, column);
        }
    }

    public class Cell {
        private final int rowIndex;
        private final int cellIndex;

        protected Cell(int rowIndex, int cellIndex) {
            this.cellIndex = cellIndex;
            this.rowIndex = rowIndex;
        }

        public int getCellIndex() {
            return this.cellIndex;
        }

        public Element getElement() {
            return DOM.asOld(HTMLTable.this.getCellFormatter().getElement(this.rowIndex, this.cellIndex));
        }

        public int getRowIndex() {
            return this.rowIndex;
        }
    }

    private static class HTMLTableIEImpl
    implements HTMLTableImpl {
        private HTMLTableIEImpl() {
        }

        @Override
        public native JsArray<com.google.gwt.dom.client.Element> getRows(com.google.gwt.dom.client.Element var1);

        @Override
        public native JsArray<com.google.gwt.dom.client.Element> getCells(com.google.gwt.dom.client.Element var1);
    }

    private static class HTMLTableStandardImpl
    implements HTMLTableImpl {
        private HTMLTableStandardImpl() {
        }

        @Override
        public native JsArray<com.google.gwt.dom.client.Element> getRows(com.google.gwt.dom.client.Element var1);

        @Override
        public native JsArray<com.google.gwt.dom.client.Element> getCells(com.google.gwt.dom.client.Element var1);
    }

    private static interface HTMLTableImpl {
        public JsArray<com.google.gwt.dom.client.Element> getRows(com.google.gwt.dom.client.Element var1);

        public JsArray<com.google.gwt.dom.client.Element> getCells(com.google.gwt.dom.client.Element var1);
    }
}

